"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSetupRow = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _index_setup_dataset_filter = require("./index_setup_dataset_filter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexSetupRow = ({
  index,
  isDisabled,
  onChangeDatasetFilter,
  onChangeIsSelected,
  previousQualityWarnings
}) => {
  const changeIsSelected = (0, _react.useCallback)(event => {
    onChangeIsSelected(index.name, event.currentTarget.checked);
  }, [index.name, onChangeIsSelected]);
  const changeDatasetFilter = (0, _react.useCallback)(datasetFilter => onChangeDatasetFilter(index.name, datasetFilter), [index.name, onChangeDatasetFilter]);
  const datasets = (0, _react.useMemo)(() => index.validity === 'valid' ? index.availableDatasets.map(availableDataset => ({
    dataset: availableDataset,
    warnings: previousQualityWarnings.filter(({
      dataset
    }) => dataset === availableDataset)
  })) : [], [index, previousQualityWarnings]);
  const datasetIndependentQualityWarnings = (0, _react.useMemo)(() => previousQualityWarnings.filter(({
    dataset
  }) => dataset === ''), [previousQualityWarnings]);
  const hasWarnings = (0, _react.useMemo)(() => datasetIndependentQualityWarnings.length > 0 || datasets.some(({
    warnings
  }) => warnings.length > 0), [datasetIndependentQualityWarnings, datasets]);
  const isSelected = index.validity === 'valid' && index.isSelected;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    key: index.name,
    id: index.name,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index.name, index.validity === 'valid' && hasWarnings ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logs.analsysisSetup.indexQualityWarningTooltipMessage",
        defaultMessage: "While analyzing the log messages from these indices we've detected some problems which might indicate a reduced quality of the results. Consider excluding these indices or problematic datasets from the analysis."
      }),
      type: "warning",
      color: "warning"
    }) : null),
    onChange: changeIsSelected,
    checked: isSelected,
    disabled: isDisabled || index.validity === 'invalid'
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, index.validity === 'invalid' ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "textSubduedColor"
  }, formatValidationError(index.errors)) : index.validity === 'valid' ? /*#__PURE__*/_react.default.createElement(_index_setup_dataset_filter.IndexSetupDatasetFilter, {
    availableDatasets: datasets,
    datasetFilter: index.datasetFilter,
    isDisabled: !isSelected || isDisabled,
    onChangeDatasetFilter: changeDatasetFilter
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
exports.IndexSetupRow = IndexSetupRow;
const formatValidationError = errors => {
  return errors.map(error => {
    switch (error.error) {
      case 'INDEX_NOT_FOUND':
        return /*#__PURE__*/_react.default.createElement("p", {
          key: `${error.error}-${error.index}`
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.analysisSetup.indicesSelectionIndexNotFound",
          defaultMessage: "No indices match the pattern {index}",
          values: {
            index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, error.index)
          }
        }));
      case 'FIELD_NOT_FOUND':
        return /*#__PURE__*/_react.default.createElement("p", {
          key: `${error.error}-${error.index}-${error.field}`
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.analysisSetup.indicesSelectionNoTimestampField",
          defaultMessage: "At least one index matching {index} lacks a required field {field}.",
          values: {
            index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, error.index),
            field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, error.field)
          }
        }));
      case 'FIELD_NOT_VALID':
        return /*#__PURE__*/_react.default.createElement("p", {
          key: `${error.error}-${error.index}-${error.field}`
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.analysisSetup.indicesSelectionTimestampNotValid",
          defaultMessage: "At least one index matching {index} has a field called {field} without the correct type.",
          values: {
            index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, error.index),
            field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, error.field)
          }
        }));
      default:
        return '';
    }
  });
};