"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_lens_attributes = require("../../hooks/use_lens_attributes");
var _lens_wrapper = require("./lens_wrapper");
var _chart_load_error = require("./chart_load_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_HEIGHT = 300;
const LensChart = /*#__PURE__*/_react.default.memo(({
  id,
  borderRadius,
  dateRange,
  filters,
  hidePanelTitles,
  lastReloadRequestTime,
  query,
  onBrushEnd,
  onFilter,
  overrides,
  toolTip,
  searchSessionId,
  disableTriggers = false,
  height = MIN_HEIGHT,
  loading = false,
  ...lensAttributesParams
}) => {
  const {
    formula,
    attributes,
    getExtraActions,
    error
  } = (0, _use_lens_attributes.useLensAttributes)(lensAttributesParams);
  const isLoading = loading || !attributes;
  const extraActions = getExtraActions({
    timeRange: dateRange,
    query,
    filters,
    searchSessionId
  });
  const lens = /*#__PURE__*/_react.default.createElement(_lens_wrapper.LensWrapper, {
    id: id,
    attributes: attributes,
    dateRange: dateRange,
    disableTriggers: disableTriggers,
    extraActions: extraActions,
    filters: filters,
    hidePanelTitles: hidePanelTitles,
    loading: isLoading,
    style: {
      height
    },
    query: query,
    overrides: overrides,
    onBrushEnd: onBrushEnd,
    searchSessionId: searchSessionId,
    onFilter: onFilter
  });
  const content = !toolTip ? lens : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "regular",
    content: /*#__PURE__*/_react.default.cloneElement(toolTip, {
      formula
    }),
    anchorClassName: "eui-fullWidth"
  }, /*#__PURE__*/_react.default.createElement("div", null, lens));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: !!borderRadius,
    borderRadius: borderRadius,
    hasShadow: false,
    paddingSize: error ? 'm' : 'none',
    "data-test-subj": id,
    css: (0, _react2.css)`
          position: relative;
          min-height: ${height}px;
        `
  }, error ? /*#__PURE__*/_react.default.createElement(_chart_load_error.ChartLoadError, null) : content);
});
exports.LensChart = LensChart;