"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DescriptionCallout = DescriptionCallout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_KEY = 'infra-profiling-description-callout-dismissed';
function DescriptionCallout() {
  const [isDismissed, setIsDismissed] = (0, _useLocalStorage.default)(LOCAL_STORAGE_KEY, false);
  const onDismissClick = (0, _react.useCallback)(() => setIsDismissed(true), [setIsDismissed]);
  if (isDismissed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.infra.profiling.descriptionCallout.title', {
      defaultMessage: 'Displaying Resource Consumption for this Host'
    }),
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.infra.profiling.descriptionCallout.body', {
    defaultMessage: 'Universal Profiling helps you optimize resource usage and find performance bottlenecks by showing which lines of code are consuming resources on your host, down to the application code, kernel, and third-party libraries.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraProfilingDescriptionCalloutLearnMoreLink",
    href: "https://www.elastic.co/guide/en/observability/current/profiling-get-started.html",
    external: true,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.infra.profiling.descriptionCallout.learnMore', {
    defaultMessage: 'Learn more'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraDescriptionCalloutDismissButton",
    onClick: onDismissClick
  }, _i18n.i18n.translate('xpack.infra.profiling.descriptionCallout.dismiss', {
    defaultMessage: 'Dismiss'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
}