"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Processes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _parse_search_string = require("./parse_search_string");
var _processes_table = require("./processes_table");
var _states = require("./states");
var _summary_table = require("./summary_table");
var _use_process_list = require("../../hooks/use_process_list");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_date_picker = require("../../hooks/use_date_picker");
var _processes_explanation = require("../../components/processes_explanation");
var _use_asset_details_url_state = require("../../hooks/use_asset_details_url_state");
var _top_processes_tooltip = require("../../components/top_processes_tooltip");
var _use_intersecting_state = require("../../hooks/use_intersecting_state");
var _use_request_observable = require("../../hooks/use_request_observable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = Object.entries(_states.STATE_NAMES).map(([value, view]) => ({
  value,
  view
}));
const Processes = () => {
  var _urlState$processSear, _ref, _response$processList, _response$processList2;
  const ref = (0, _react.useRef)(null);
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    getDateRangeInTimestamp
  } = (0, _use_date_picker.useDatePickerContext)();
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const [searchText, setSearchText] = (0, _react.useState)((_urlState$processSear = urlState === null || urlState === void 0 ? void 0 : urlState.processSearch) !== null && _urlState$processSear !== void 0 ? _urlState$processSear : '');
  const [searchQueryError, setSearchQueryError] = (0, _react.useState)(null);
  const [searchBarState, setSearchBarState] = (0, _react.useState)(() => searchText ? _eui.Query.parse(searchText) : _eui.Query.MATCH_ALL);
  const toTimestamp = (0, _react.useMemo)(() => getDateRangeInTimestamp().to, [getDateRangeInTimestamp]);
  const state = (0, _use_intersecting_state.useIntersectingState)(ref, {
    currentTimestamp: toTimestamp
  });
  const [sortBy, setSortBy] = (0, _react.useState)({
    name: 'cpu',
    isAscending: false
  });
  const hostTerm = (0, _react.useMemo)(() => {
    var _getFieldByType;
    const field = (_getFieldByType = (0, _common.getFieldByType)(asset.type)) !== null && _getFieldByType !== void 0 ? _getFieldByType : asset.type;
    return {
      [field]: asset.name
    };
  }, [asset.name, asset.type]);
  const {
    loading,
    error,
    response,
    makeRequest: reload
  } = (0, _use_process_list.useProcessList)(hostTerm, state.currentTimestamp, sortBy, (0, _parse_search_string.parseSearchString)(searchText), request$);
  const debouncedSearchOnChange = (0, _react.useMemo)(() => {
    return (0, _lodash.debounce)(queryText => {
      setSearchText(queryText);
    }, 500);
  }, []);
  const searchBarOnChange = (0, _react.useCallback)(({
    query,
    queryText,
    error: queryError
  }) => {
    if (queryError) {
      setSearchQueryError(queryError);
    } else {
      setUrlState({
        processSearch: queryText
      });
      setSearchQueryError(null);
      setSearchBarState(query);
      debouncedSearchOnChange(queryText);
    }
  }, [debouncedSearchOnChange, setUrlState]);
  const clearSearchBar = (0, _react.useCallback)(() => {
    setSearchBarState(_eui.Query.MATCH_ALL);
    setUrlState({
      processSearch: ''
    });
    setSearchQueryError(null);
    setSearchText('');
  }, [setUrlState]);
  return /*#__PURE__*/_react.default.createElement(_use_process_list.ProcessListContextProvider, {
    hostTerm: hostTerm,
    to: state.currentTimestamp
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_summary_table.SummaryTable, {
    isLoading: loading && !response,
    processSummary: (_ref = !error ? response === null || response === void 0 ? void 0 : response.summary : null) !== null && _ref !== void 0 ? _ref : {
      total: 0
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "infraAssetDetailsTopProcessesTitle",
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metrics.nodeDetails.processesHeader",
    defaultMessage: "Top processes"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_top_processes_tooltip.TopProcessesTooltip, null))), !error && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, loading && !response ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : ((_response$processList = response === null || response === void 0 ? void 0 : response.processList) !== null && _response$processList !== void 0 ? _response$processList : []).length > 0 && /*#__PURE__*/_react.default.createElement(_processes_explanation.ProcessesExplanationMessage, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: searchBarState,
    onChange: searchBarOnChange,
    box: {
      'data-test-subj': 'infraAssetDetailsProcessesSearchBarInput',
      incremental: true,
      placeholder: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.searchForProcesses', {
        defaultMessage: 'Search for processes…'
      })
    },
    filters: [{
      type: 'field_value_selection',
      field: 'state',
      name: 'State',
      operator: 'exact',
      multiSelect: false,
      options
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !error ? /*#__PURE__*/_react.default.createElement(_processes_table.ProcessesTable, {
    currentTime: state.currentTimestamp,
    isLoading: loading || !response,
    processList: (_response$processList2 = response === null || response === void 0 ? void 0 : response.processList) !== null && _response$processList2 !== void 0 ? _response$processList2 : [],
    sortBy: sortBy,
    error: searchQueryError === null || searchQueryError === void 0 ? void 0 : searchQueryError.message,
    setSortBy: setSortBy,
    clearSearchBar: clearSearchBar
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.processListError",
      defaultMessage: "Unable to load process data"
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraAssetDetailsTabComponentTryAgainButton",
      color: "primary",
      fill: true,
      onClick: reload
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.processListRetry",
      defaultMessage: "Try again"
    }))
  }))));
};
exports.Processes = Processes;