"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsSummaryContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-plugin/public");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _plugin_config_context = require("../../../../containers/plugin_config_context");
var _create_alerts_es_query = require("../../../../common/alerts/create_alerts_es_query");
var _config = require("../../../../pages/metrics/hosts/components/tabs/config");
var _use_kibana = require("../../../../hooks/use_kibana");
var _link_to_alerts = require("../../links/link_to_alerts");
var _link_to_alerts_page = require("../../links/link_to_alerts_page");
var _alert_flyout = require("../../../../alerting/inventory/components/alert_flyout");
var _use_boolean = require("../../../../hooks/use_boolean");
var _constants = require("../../../../common/alerts/constants");
var _section_titles = require("../../components/section_titles");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsSummaryContent = ({
  assetName,
  assetType,
  dateRange
}) => {
  var _overrides$alertRule;
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  const [isAlertFlyoutVisible, {
    toggle: toggleAlertFlyout
  }] = (0, _use_boolean.useBoolean)(false);
  const {
    overrides
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const alertsEsQueryByStatus = (0, _react.useMemo)(() => (0, _create_alerts_es_query.createAlertsEsQuery)({
    dateRange,
    hostNodeNames: [assetName],
    status: _constants.ALERT_STATUS_ALL
  }), [assetName, dateRange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_section_titles.AlertsSectionTitle, null)), featureFlags.inventoryThresholdAlertRuleEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_link_to_alerts.LinkToAlertsRule, {
    onClick: toggleAlertFlyout
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_link_to_alerts_page.LinkToAlertsPage, {
    assetName: assetName,
    queryField: `${assetType}.name`,
    dateRange: dateRange
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(MemoAlertSummaryWidget, {
    alertsQuery: alertsEsQueryByStatus,
    dateRange: dateRange
  }), featureFlags.inventoryThresholdAlertRuleEnabled && /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
    filter: `${(0, _common.findInventoryFields)(assetType).name}: "${assetName}"`,
    nodeType: assetType,
    setVisible: toggleAlertFlyout,
    visible: isAlertFlyoutVisible,
    options: overrides === null || overrides === void 0 ? void 0 : (_overrides$alertRule = overrides.alertRule) === null || _overrides$alertRule === void 0 ? void 0 : _overrides$alertRule.options
  }));
};
exports.AlertsSummaryContent = AlertsSummaryContent;
const MemoAlertSummaryWidget = /*#__PURE__*/_react.default.memo(({
  alertsQuery,
  dateRange
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const summaryTimeRange = (0, _public.useSummaryTimeRange)(dateRange);
  const {
    charts,
    triggersActionsUi
  } = services;
  const {
    getAlertSummaryWidget: AlertSummaryWidget
  } = triggersActionsUi;
  const chartProps = {
    theme: charts.theme.useChartsTheme(),
    baseTheme: charts.theme.useChartsBaseTheme()
  };
  return /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    chartProps: chartProps,
    featureIds: _config.infraAlertFeatureIds,
    filter: alertsQuery,
    timeRange: summaryTimeRange,
    fullSize: true,
    hideChart: true
  });
});