"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Osquery = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _plugin_config_context = require("../../../../containers/plugin_config_context");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_metadata_state = require("../../hooks/use_metadata_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Osquery = () => {
  var _metadata$info, _metadata$info$agent, _agentId$current;
  const {
    metadata,
    loading
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const agentId = (0, _react.useRef)(undefined);

  // When a host has multiple agents reporting metrics, it's possible that one of them may not report an agent id.
  // This ensures that once an agent id is found, it won't be replaced.
  if (metadata !== null && metadata !== void 0 && (_metadata$info = metadata.info) !== null && _metadata$info !== void 0 && (_metadata$info$agent = _metadata$info.agent) !== null && _metadata$info$agent !== void 0 && _metadata$info$agent.id && !agentId.current) {
    agentId.current = metadata.info.agent.id;
  }
  const {
    featureFlags
  } = (0, _plugin_config_context.usePluginConfig)();
  if (!featureFlags.osqueryEnabled) {
    return null;
  }
  const isLoading = loading && !metadata;
  return isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  }) :
  /*#__PURE__*/
  // Osquery must receive an agent id for it to function in infra. There may be incomplete metric documents without this information, causing the metadata endpoint to return incomplete data.
  // To prevent incorrect Osquery form rendering, we're passing an invalid agent id. This ensures the user sees the 'not available' message instead of the form.
  _react.default.createElement(MemoOsQueryAction, {
    agentId: (_agentId$current = agentId.current) !== null && _agentId$current !== void 0 ? _agentId$current : '_na'
  });
};
exports.Osquery = Osquery;
const MemoOsQueryAction = /*#__PURE__*/_react.default.memo(({
  agentId
}) => {
  const {
    services: {
      osquery
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();

  // @ts-expect-error
  const OsqueryAction = osquery === null || osquery === void 0 ? void 0 : osquery.OsqueryAction;
  return !OsqueryAction ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10
  }) : /*#__PURE__*/_react.default.createElement(OsqueryAction, {
    agentId: agentId,
    hideAgentsField: true,
    formType: "simple"
  });
});