"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Metadata = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _table = require("./table");
var _utils = require("./utils");
var _use_metadata_state = require("../../hooks/use_metadata_state");
var _metadata_explanation = require("../../components/metadata_explanation");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_asset_details_url_state = require("../../hooks/use_asset_details_url_state");
var _metadata_error_callout = require("../../components/metadata_error_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Metadata = () => {
  var _overrides$metadata;
  const [urlState, setUrlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    overrides
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metadata,
    loading: metadataLoading,
    error: fetchMetadataError
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    showActionsColumn = false
  } = (_overrides$metadata = overrides === null || overrides === void 0 ? void 0 : overrides.metadata) !== null && _overrides$metadata !== void 0 ? _overrides$metadata : {};
  const fields = (0, _react.useMemo)(() => (0, _utils.getAllFields)(metadata), [metadata]);
  const onSearchChange = (0, _react.useCallback)(newQuery => {
    setUrlState({
      metadataSearch: newQuery
    });
  }, [setUrlState]);
  if (fetchMetadataError && !metadataLoading) {
    return /*#__PURE__*/_react.default.createElement(_metadata_error_callout.MetadataErrorCallout, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metadata_explanation.MetadataExplanationMessage, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_table.Table, {
    search: urlState === null || urlState === void 0 ? void 0 : urlState.metadataSearch,
    onSearchChange: onSearchChange,
    showActionsColumn: showActionsColumn,
    rows: fields,
    loading: metadataLoading
  }));
};

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
exports.Metadata = Metadata;
var _default = Metadata;
exports.default = _default;