"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToAlertsPage = exports.LinkToAlertsHomePage = void 0;
var _react = _interopRequireDefault(require("react"));
var _rison = require("@kbn/rison");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/alerts/constants");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkToAlertsPage = ({
  assetName,
  queryField,
  dateRange
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    http
  } = services;
  const linkToAlertsPage = http.basePath.prepend(`${_constants.ALERTS_PATH}?_a=${(0, _rison.encode)({
    kuery: `${queryField}:"${assetName}"`,
    rangeFrom: dateRange.from,
    rangeTo: dateRange.to,
    status: 'all'
  })}`);
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: services
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraAssetDetailsAlertsShowAllButton",
    size: "xs",
    iconSide: "right",
    iconType: "sortRight",
    flush: "both",
    href: linkToAlertsPage
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.flyout.AlertsPageLinkLabel",
    defaultMessage: "Show all"
  })));
};
exports.LinkToAlertsPage = LinkToAlertsPage;
const LinkToAlertsHomePage = () => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    http
  } = services;
  const linkToAlertsPage = http.basePath.prepend(_constants.ALERTS_PATH);
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: services
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "assetDetailsTooltipDocumentationLink",
    href: linkToAlertsPage
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.table.tooltip.alertsLink",
    defaultMessage: "alerts."
  })));
};
exports.LinkToAlertsHomePage = LinkToAlertsHomePage;