"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetDetailsUrlState = exports.DEFAULT_STATE = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _react = require("react");
var _types = require("../types");
var _use_url_state = require("../../../utils/use_url_state");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STATE = {
  tabId: _types.ContentTabIds.OVERVIEW
};
exports.DEFAULT_STATE = DEFAULT_STATE;
const useAssetDetailsUrlState = () => {
  const [urlState, setUrlState] = (0, _use_url_state.useUrlState)({
    defaultState: null,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: _constants.ASSET_DETAILS_URL_STATE_KEY
  });
  const setAssetDetailsState = (0, _react.useCallback)(newProps => {
    if (!newProps) {
      setUrlState(null);
    } else {
      const payload = Object.fromEntries(Object.entries(newProps !== null && newProps !== void 0 ? newProps : {}).filter(([_, v]) => !!v || v === ''));
      setUrlState(previous => ({
        ...previous,
        ...payload
      }));
    }
  }, [setUrlState]);
  return [urlState, setAssetDetailsState];
};
exports.useAssetDetailsUrlState = useAssetDetailsUrlState;
const TabIdRT = rt.union([rt.literal(_types.ContentTabIds.OVERVIEW), rt.literal(_types.ContentTabIds.METADATA), rt.literal(_types.ContentTabIds.PROCESSES), rt.literal(_types.ContentTabIds.PROFILING), rt.literal(_types.ContentTabIds.LOGS), rt.literal(_types.ContentTabIds.ANOMALIES), rt.literal(_types.ContentTabIds.OSQUERY)]);
const AssetDetailsUrlStateRT = rt.partial({
  autoRefresh: rt.partial({
    isPaused: rt.boolean,
    interval: rt.number
  }),
  dateRange: rt.type({
    from: rt.string,
    to: rt.string
  }),
  tabId: TabIdRT,
  name: rt.string,
  processSearch: rt.string,
  metadataSearch: rt.string,
  logsSearch: rt.string
});
const AssetDetailsUrlRT = rt.union([AssetDetailsUrlStateRT, rt.null]);
const encodeUrlState = AssetDetailsUrlRT.encode;
const decodeUrlState = value => {
  return (0, _pipeable.pipe)(AssetDetailsUrlRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
};