"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailsRenderPropsProvider = exports.AssetDetailsRenderProps = void 0;
exports.useAssetDetailsRenderProps = useAssetDetailsRenderProps;
exports.useAssetDetailsRenderPropsContext = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _use_asset_details_url_state = require("./use_asset_details_url_state");
var _use_metadata_state = require("./use_metadata_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAssetDetailsRenderProps(props) {
  const [urlState] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    metadata
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    assetId,
    assetName,
    assetType,
    ...rest
  } = props;

  // When the asset asset.name is known we can load the page faster
  // Otherwise we need to use metadata response.
  const loading = !assetName && !(urlState !== null && urlState !== void 0 && urlState.name) && !(metadata !== null && metadata !== void 0 && metadata.name);
  return {
    ...rest,
    asset: {
      id: assetId,
      name: assetName || (urlState === null || urlState === void 0 ? void 0 : urlState.name) || (metadata === null || metadata === void 0 ? void 0 : metadata.name) || '',
      type: assetType
    },
    loading
  };
}
const AssetDetailsRenderProps = (0, _constate.default)(useAssetDetailsRenderProps);
exports.AssetDetailsRenderProps = AssetDetailsRenderProps;
const [AssetDetailsRenderPropsProvider, useAssetDetailsRenderPropsContext] = AssetDetailsRenderProps;
exports.useAssetDetailsRenderPropsContext = useAssetDetailsRenderPropsContext;
exports.AssetDetailsRenderPropsProvider = AssetDetailsRenderPropsProvider;