"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_date_picker = require("../hooks/use_date_picker");
var _use_loading_state = require("../hooks/use_loading_state");
var _popover = require("../tabs/common/popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COMMONLY_USED_RANGES = [{
  start: 'now-15m',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last15Minutes', {
    defaultMessage: 'Last 15 minutes'
  })
}, {
  start: 'now-1h',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last1Hour', {
    defaultMessage: 'Last 1 hour'
  })
}, {
  start: 'now-3h',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last3Hours', {
    defaultMessage: 'Last 3 hours'
  })
}, {
  start: 'now-24h',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last24Hours', {
    defaultMessage: 'Last 24 hours'
  })
}, {
  start: 'now-7d',
  end: 'now',
  label: _i18n.i18n.translate('xpack.infra.assetDetails.datePicker.commonlyUsedRanges.last7Days', {
    defaultMessage: 'Last 7 days'
  })
}];
const DatePicker = () => {
  const {
    dateRange,
    autoRefresh,
    setDateRange,
    setAutoRefresh,
    onAutoRefresh
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    updateSearchSessionId
  } = (0, _use_loading_state.useLoadingStateContext)();
  const handleRefresh = (0, _react.useCallback)(({
    start,
    end
  }) => {
    onAutoRefresh({
      from: start,
      to: end
    });
  }, [onAutoRefresh]);
  const handleTimeChange = (0, _react.useCallback)(({
    start,
    end,
    isInvalid
  }) => {
    if (!isInvalid) {
      setDateRange({
        from: start,
        to: end
      });
    }
  }, [setDateRange]);
  const handleAutoRefreshChange = (0, _react.useCallback)(({
    isPaused,
    refreshInterval
  }) => {
    setAutoRefresh({
      isPaused,
      interval: refreshInterval
    });
    if (!isPaused) {
      // when auto refresh is enabled, we need to force the end range to `now` in order for it to work automatically
      // otherwise,  users have to manually set `now` in the date picker
      setDateRange({
        from: dateRange.from,
        to: 'now'
      });
    }
  }, [dateRange.from, setAutoRefresh, setDateRange]);
  const handleOnClick = (0, _react.useCallback)(() => updateSearchSessionId(), [updateSearchSessionId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(MemoEuiSuperDatePicker, {
    commonlyUsedRanges: COMMONLY_USED_RANGES,
    start: dateRange.from,
    end: dateRange.to,
    isPaused: autoRefresh === null || autoRefresh === void 0 ? void 0 : autoRefresh.isPaused,
    onTimeChange: handleTimeChange,
    onRefresh: autoRefresh && handleRefresh,
    onRefreshChange: autoRefresh && handleAutoRefreshChange,
    refreshInterval: autoRefresh === null || autoRefresh === void 0 ? void 0 : autoRefresh.interval,
    onClick: handleOnClick,
    width: "full"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minHeight: '18px'
    }
  }, autoRefresh && !autoRefresh.isPaused && /*#__PURE__*/_react.default.createElement(AutoRefreshTroubleshootMessage, null)));
};
exports.DatePicker = DatePicker;
const AutoRefreshTroubleshootMessage = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "xs",
  alignItems: "baseline",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.assetDetails.datePicker.tooltip.autoRefresh",
  defaultMessage: "Experiencing continually loading data?"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
  iconSize: "s",
  iconColor: "subdued",
  icon: "iInCircle",
  "data-test-subj": "infraAssetDetailsMetadataPopoverButton"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.assetDetails.datePicker.tooltip.autoRefresh.troubleshoot",
  defaultMessage: "Try increasing the refresh interval, shortening the date range or turning off auto-refresh."
})))));

// Memo EuiSuperDatePicker to prevent re-renders from resetting the auto-refresh cycle
const MemoEuiSuperDatePicker = /*#__PURE__*/_react.default.memo(({
  onClick,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, (0, _extends2.default)({}, props, {
  updateButtonProps: {
    iconOnly: true,
    contentProps: {
      onClick
    }
  }
})));