"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-utils-plugin/public");
require("../index.scss");
var _link_to_logs = require("../pages/link_to/link_to_logs");
var _logs = require("../pages/logs");
var _common_providers = require("./common_providers");
var _common_styles = require("./common_styles");
var _kbn_url_state_context = require("../utils/kbn_url_state_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = (core, plugins, pluginStart, {
  element,
  history,
  setHeaderActionMenu,
  theme$
}) => {
  const storage = new _public.Storage(window.localStorage);
  (0, _common_styles.prepareMountElement)(element, 'infraLogsPage');
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(LogsApp, {
    core: core,
    storage: storage,
    history: history,
    plugins: plugins,
    pluginStart: pluginStart,
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;
const LogsApp = ({
  core,
  history,
  pluginStart,
  plugins,
  setHeaderActionMenu,
  storage,
  theme$
}) => {
  var _uiCapabilities$logs;
  const uiCapabilities = core.application.capabilities;
  return /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, {
    core: core,
    pluginStart: pluginStart,
    plugins: plugins,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_common_providers.CommonInfraProviders, {
    appName: "Logs UI",
    setHeaderActionMenu: setHeaderActionMenu,
    storage: storage,
    theme$: theme$,
    triggersActionsUI: plugins.triggersActionsUi,
    observabilityAIAssistant: plugins.observabilityAIAssistant
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_kbn_url_state_context.KbnUrlStateStorageFromRouterProvider, {
    history: history,
    toastsService: core.notifications.toasts
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/link-to",
    component: _link_to_logs.LinkToLogsPage
  }), (uiCapabilities === null || uiCapabilities === void 0 ? void 0 : (_uiCapabilities$logs = uiCapabilities.logs) === null || _uiCapabilities$logs === void 0 ? void 0 : _uiCapabilities$logs.show) && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    component: _logs.LogsPage
  }))))));
};