"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerReloadRoute = registerReloadRoute;
var _lodash = require("lodash");
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
var _fetch_indices = require("../../../lib/fetch_indices");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bodySchema = _configSchema.schema.maybe(_configSchema.schema.object({
  indexNames: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
}));
function registerReloadRoute({
  router,
  indexDataEnricher,
  lib: {
    handleEsError
  },
  config
}) {
  router.post({
    path: (0, _.addBasePath)('/indices/reload'),
    validate: {
      body: bodySchema
    }
  }, async (context, request, response) => {
    var _ref;
    const {
      client
    } = (await context.core).elasticsearch;
    const {
      indexNames = []
    } = (_ref = request.body) !== null && _ref !== void 0 ? _ref : {};
    try {
      let indices;

      // When the number of indices is small, we can execute in a single request
      //
      // Otherwise we need to split the indices into chunks and execute them in multiple requests because
      // if we try to execute an action with too many indices that account for a long string in the request
      // ES will throw an error saying that the HTTP line is too large.
      if (indexNames.length <= _constants.MAX_INDICES_PER_REQUEST) {
        indices = await (0, _fetch_indices.fetchIndices)({
          client,
          indexDataEnricher,
          config,
          indexNames
        });
      } else {
        const chunks = (0, _lodash.chunk)(indexNames, _constants.MAX_INDICES_PER_REQUEST);
        indices = (await Promise.all(chunks.map(indexNamesChunk => (0, _fetch_indices.fetchIndices)({
          client,
          indexDataEnricher,
          config,
          indexNames: indexNamesChunk
        })))).flat();
      }
      return response.ok({
        body: indices
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}