"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performExtensionAction = void 0;
var _ = require(".");
var _notification = require("../../services/notification");
var _http = require("../../services/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const performExtensionAction = ({
  requestMethod,
  indexNames,
  successMessage
}) => async dispatch => {
  try {
    await requestMethod(indexNames, _http.httpService.httpClient);
  } catch (error) {
    _notification.notificationService.showDangerToast(error.message);
    return;
  }
  dispatch((0, _.reloadIndices)(indexNames));
  _notification.notificationService.showSuccessToast(successMessage);
};
exports.performExtensionAction = performExtensionAction;