"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderBadges = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderBadges = (index, extensionsService, onFilterChange) => {
  const badgeLabels = [];
  extensionsService.badges.forEach(({
    matchIndex,
    label,
    color,
    filterExpression
  }) => {
    if (matchIndex(index)) {
      const clickHandler = () => {
        if (onFilterChange && filterExpression) {
          onFilterChange(_eui.Query.parse(filterExpression));
        }
      };
      const ariaLabel = _i18n.i18n.translate('xpack.idxMgmt.badgeAriaLabel', {
        defaultMessage: '{label}. Select to filter on this.',
        values: {
          label
        }
      });
      const badge = onFilterChange && filterExpression ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: color,
        onClick: clickHandler,
        onClickAriaLabel: ariaLabel
      }, label) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: color
      }, label);
      badgeLabels.push( /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: label
      }, " ", badge));
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, badgeLabels);
};
exports.renderBadges = renderBadges;