"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexStatusLabels = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexStatusLabels = {
  [_constants.INDEX_CLEARING_CACHE]: _i18n.i18n.translate('xpack.idxMgmt.indexStatusLabels.clearingCacheStatusLabel', {
    defaultMessage: 'clearing cache...'
  }),
  [_constants.INDEX_CLOSED]: _i18n.i18n.translate('xpack.idxMgmt.indexStatusLabels.closedStatusLabel', {
    defaultMessage: 'closed'
  }),
  [_constants.INDEX_CLOSING]: _i18n.i18n.translate('xpack.idxMgmt.indexStatusLabels.closingStatusLabel', {
    defaultMessage: 'closing...'
  }),
  [_constants.INDEX_MERGING]: _i18n.i18n.translate('xpack.idxMgmt.indexStatusLabels.mergingStatusLabel', {
    defaultMessage: 'merging...'
  }),
  [_constants.INDEX_OPENING]: _i18n.i18n.translate('xpack.idxMgmt.indexStatusLabels.openingStatusLabel', {
    defaultMessage: 'opening...'
  }),
  [_constants.INDEX_REFRESHING]: _i18n.i18n.translate('xpack.idxMgmt.indexStatusLabels.refreshingStatusLabel', {
    defaultMessage: 'refreshing...'
  }),
  [_constants.INDEX_FLUSHING]: _i18n.i18n.translate('xpack.idxMgmt.indexStatusLabels.flushingStatusLabel', {
    defaultMessage: 'flushing...'
  }),
  [_constants.INDEX_FORCEMERGING]: _i18n.i18n.translate('xpack.idxMgmt.indexStatusLabels.forcingMergeStatusLabel', {
    defaultMessage: 'forcing merge...'
  })
};
exports.indexStatusLabels = indexStatusLabels;