"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultFlyoutProps = exports.EditFieldContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ = require("../../../../../..");
var _shared_imports = require("../../../../shared_imports");
var _mappings_state_context = require("../../../../mappings_state_context");
var _lib = require("../../../../lib");
var _modal_confirmation_delete_fields = require("../modal_confirmation_delete_fields");
var _edit_field = require("./edit_field");
var _use_update_field = require("./use_update_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultFlyoutProps = {
  'data-test-subj': 'mappingsEditorFieldEdit',
  'aria-labelledby': 'mappingsEditorFieldEditTitle',
  className: 'mappingsEditor__editField',
  maxWidth: 720
};
exports.defaultFlyoutProps = defaultFlyoutProps;
const EditFieldContainer = /*#__PURE__*/_react.default.memo(({
  exitEdit
}) => {
  const {
    fields,
    documentFields
  } = (0, _mappings_state_context.useMappingsState)();
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    updateField,
    modal
  } = (0, _use_update_field.useUpdateField)();
  const {
    services: {
      kibanaVersion
    }
  } = (0, _.useKibana)();
  const {
    status,
    fieldToEdit
  } = documentFields;
  const isEditing = status === 'editingField';
  const field = fields.byId[fieldToEdit];
  const formDefaultValue = (0, _react.useMemo)(() => {
    return {
      ...(field === null || field === void 0 ? void 0 : field.source)
    };
  }, [field === null || field === void 0 ? void 0 : field.source]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: formDefaultValue,
    serializer: _lib.fieldSerializer,
    deserializer: _lib.fieldDeserializer,
    options: {
      stripEmptyFields: false
    },
    id: 'edit-field'
  });
  const {
    subscribe
  } = form;
  (0, _react.useEffect)(() => {
    const subscription = subscribe(updatedFieldForm => {
      dispatch({
        type: 'fieldForm.update',
        value: updatedFieldForm
      });
    });
    return subscription.unsubscribe;
  }, [subscribe, dispatch]);
  const renderModal = () => {
    return modal.isOpen ? /*#__PURE__*/_react.default.createElement(_modal_confirmation_delete_fields.ModalConfirmationDeleteFields, modal.props) : null;
  };
  if (!isEditing) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.EditField, {
    form: form,
    field: field,
    allFields: fields.byId,
    exitEdit: exitEdit,
    updateField: updateField,
    kibanaVersion: kibanaVersion.get()
  }), renderModal());
});
exports.EditFieldContainer = EditFieldContainer;