"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../shared_imports");
var _constants = require("../../constants");
var _mappings_state_context = require("../../mappings_state_context");
var _dynamic_mapping_section = require("./dynamic_mapping_section");
var _source_field_section = require("./source_field_section");
var _meta_field_section = require("./meta_field_section");
var _routing_section = require("./routing_section");
var _mapper_size_plugin_section = require("./mapper_size_plugin_section");
var _configuration_form_schema = require("./configuration_form_schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formSerializer = formData => {
  const {
    dynamicMapping: {
      enabled: dynamicMappingsEnabled,
      throwErrorsForUnmappedFields,
      /* eslint-disable @typescript-eslint/naming-convention */
      numeric_detection,
      date_detection,
      dynamic_date_formats
      /* eslint-enable @typescript-eslint/naming-convention */
    },

    sourceField,
    metaField,
    _routing,
    _size
  } = formData;
  const dynamic = dynamicMappingsEnabled ? true : throwErrorsForUnmappedFields ? 'strict' : false;
  const serialized = {
    dynamic,
    numeric_detection,
    date_detection,
    dynamic_date_formats,
    _source: sourceField,
    _meta: metaField,
    _routing,
    _size
  };
  return serialized;
};
const formDeserializer = formData => {
  const {
    dynamic,
    /* eslint-disable @typescript-eslint/naming-convention */
    numeric_detection,
    date_detection,
    dynamic_date_formats,
    /* eslint-enable @typescript-eslint/naming-convention */
    _source: {
      enabled,
      includes,
      excludes
    } = {},
    _meta,
    _routing,
    // For the Mapper Size plugin
    _size
  } = formData;
  return {
    dynamicMapping: {
      enabled: dynamic === true || dynamic === undefined,
      throwErrorsForUnmappedFields: dynamic === 'strict',
      numeric_detection,
      date_detection,
      dynamic_date_formats
    },
    sourceField: {
      enabled: enabled === true || enabled === undefined,
      includes,
      excludes
    },
    metaField: _meta !== null && _meta !== void 0 ? _meta : {},
    _routing,
    _size
  };
};
const ConfigurationForm = /*#__PURE__*/_react.default.memo(({
  value,
  esNodesPlugins
}) => {
  const isMounted = (0, _react.useRef)(false);
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _configuration_form_schema.configurationFormSchema,
    serializer: formSerializer,
    deserializer: formDeserializer,
    defaultValue: value,
    id: 'configurationForm'
  });
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    subscribe,
    submit,
    reset,
    getFormData
  } = form;
  const isMapperSizeSectionVisible = (value === null || value === void 0 ? void 0 : value._size) !== undefined || esNodesPlugins.includes(_constants.MapperSizePluginId);
  (0, _react.useEffect)(() => {
    const subscription = subscribe(({
      data,
      isValid,
      validate
    }) => {
      dispatch({
        type: 'configuration.update',
        value: {
          data,
          isValid,
          validate,
          submitForm: submit
        }
      });
    });
    return subscription.unsubscribe;
  }, [dispatch, subscribe, submit]);
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      // If the value has changed (it probably means that we have loaded a new JSON)
      // we need to reset the form to update the fields values.
      reset({
        resetValues: true,
        defaultValue: value
      });
    }
  }, [value, reset]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;

      // Save a snapshot of the form state so we can get back to it when navigating back to the tab
      const configurationData = getFormData();
      dispatch({
        type: 'configuration.save',
        value: configurationData
      });
    };
  }, [getFormData, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    isInvalid: form.isSubmitted && !form.isValid,
    error: form.getErrors(),
    "data-test-subj": "advancedConfiguration"
  }, /*#__PURE__*/_react.default.createElement(_dynamic_mapping_section.DynamicMappingSection, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_meta_field_section.MetaFieldSection, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_source_field_section.SourceFieldSection, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_routing_section.RoutingSection, null), isMapperSizeSectionVisible && /*#__PURE__*/_react.default.createElement(_mapper_size_plugin_section.MapperSizePluginSection, null));
});
exports.ConfigurationForm = ConfigurationForm;