"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplatesDeleteModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _component_templates_context = require("../component_templates_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTemplatesDeleteModal = ({
  componentTemplatesToDelete,
  callback
}) => {
  const {
    toasts,
    api
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const numComponentTemplatesToDelete = componentTemplatesToDelete.length;
  const handleDeleteComponentTemplates = () => {
    api.deleteComponentTemplates(componentTemplatesToDelete).then(({
      data: {
        itemsDeleted,
        errors
      },
      error
    }) => {
      const hasDeletedComponentTemplates = itemsDeleted && itemsDeleted.length;
      if (hasDeletedComponentTemplates) {
        const successMessage = itemsDeleted.length === 1 ? _i18n.i18n.translate('xpack.idxMgmt.home.componentTemplates.deleteModal.successDeleteSingleNotificationMessageText', {
          defaultMessage: "Deleted component template '{componentTemplateName}'",
          values: {
            componentTemplateName: componentTemplatesToDelete[0]
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.home.componentTemplates.deleteModal.successDeleteMultipleNotificationMessageText', {
          defaultMessage: 'Deleted {numSuccesses, plural, one {# component template} other {# component templates}}',
          values: {
            numSuccesses: itemsDeleted.length
          }
        });
        callback({
          hasDeletedComponentTemplates
        });
        toasts.addSuccess(successMessage);
      }
      if (error || errors !== null && errors !== void 0 && errors.length) {
        const hasMultipleErrors = (errors === null || errors === void 0 ? void 0 : errors.length) > 1 || error && componentTemplatesToDelete.length > 1;
        const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.idxMgmt.home.componentTemplates.deleteModal.multipleErrorsNotificationMessageText', {
          defaultMessage: 'Error deleting {count} component templates',
          values: {
            count: (errors === null || errors === void 0 ? void 0 : errors.length) || componentTemplatesToDelete.length
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.home.componentTemplates.deleteModal.errorNotificationMessageText', {
          defaultMessage: "Error deleting component template '{name}'",
          values: {
            name: errors && errors[0].name || componentTemplatesToDelete[0]
          }
        });
        toasts.addDanger(errorMessage);
      }
    });
  };
  const handleOnCancel = () => {
    callback();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    "data-test-subj": "deleteComponentTemplatesConfirmation",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.componentTemplates.deleteModal.modalTitleText",
      defaultMessage: "Delete {numComponentTemplatesToDelete, plural, one {component template} other {# component templates}}",
      values: {
        numComponentTemplatesToDelete
      }
    }),
    onCancel: handleOnCancel,
    onConfirm: handleDeleteComponentTemplates,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.componentTemplates.deleteModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.componentTemplates.confirmButtonLabel",
      defaultMessage: "Delete {numComponentTemplatesToDelete, plural, one {component template} other {component templates} }",
      values: {
        numComponentTemplatesToDelete
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.home.componentTemplates.deleteModal.deleteDescription",
    defaultMessage: "You are about to delete {numComponentTemplatesToDelete, plural, one {this component template} other {these component templates} }:",
    values: {
      numComponentTemplatesToDelete
    }
  })), /*#__PURE__*/_react.default.createElement("ul", null, componentTemplatesToDelete.map(name => /*#__PURE__*/_react.default.createElement("li", {
    key: name
  }, name)))));
};
exports.ComponentTemplatesDeleteModal = ComponentTemplatesDeleteModal;