"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexLifecycleManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
var _http = require("./application/services/http");
var _ui_metric = require("./application/services/ui_metric");
var _notification = require("./application/services/notification");
var _breadcrumbs = require("./application/services/breadcrumbs");
var _extend_index_management = require("./extend_index_management");
var _locator = require("./locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class IndexLifecycleManagementPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "breadcrumbService", new _breadcrumbs.BreadcrumbService());
    this.initializerContext = initializerContext;
  }
  setup(coreSetup, plugins) {
    const {
      ui: {
        enabled: isIndexLifecycleManagementUiEnabled
      }
    } = this.initializerContext.config.get();
    if (isIndexLifecycleManagementUiEnabled) {
      const {
        http,
        notifications: {
          toasts
        },
        fatalErrors,
        getStartServices
      } = coreSetup;
      const {
        usageCollection,
        management,
        indexManagement,
        home,
        cloud
      } = plugins;

      // Initialize services even if the app isn't mounted, because they're used by index management extensions.
      (0, _http.init)(http);
      (0, _ui_metric.init)(usageCollection);
      (0, _notification.init)(toasts, fatalErrors);
      management.sections.section.data.registerApp({
        id: _constants.PLUGIN.ID,
        title: _constants.PLUGIN.TITLE,
        order: 2,
        mount: async ({
          element,
          history,
          setBreadcrumbs,
          theme$
        }) => {
          const [coreStart, {
            licensing
          }] = await getStartServices();
          const {
            chrome: {
              docTitle
            },
            i18n: {
              Context: I18nContext
            },
            application,
            docLinks,
            executionContext
          } = coreStart;
          const license = await (0, _rxjs.firstValueFrom)(licensing.license$);
          docTitle.change(_constants.PLUGIN.TITLE);
          this.breadcrumbService.setup(setBreadcrumbs);
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          const unmountAppCallback = renderApp(element, I18nContext, history, application, this.breadcrumbService, license, theme$, docLinks, executionContext, cloud);
          return () => {
            docTitle.reset();
            unmountAppCallback();
          };
        }
      });
      if (home) {
        home.featureCatalogue.register({
          id: _constants.PLUGIN.ID,
          title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.featureCatalogueTitle', {
            defaultMessage: 'Manage index lifecycles'
          }),
          description: _i18n.i18n.translate('xpack.indexLifecycleMgmt.featureCatalogueDescription', {
            defaultMessage: 'Define lifecycle policies to automatically perform operations as an index ages.'
          }),
          icon: 'indexRollupApp',
          path: '/app/management/data/index_lifecycle_management',
          showOnHomePage: true,
          category: 'admin',
          order: 640
        });
      }
      if (indexManagement) {
        (0, _extend_index_management.addAllExtensions)(indexManagement.extensionsService);
      }
      plugins.share.url.locators.create(new _locator.IlmLocatorDefinition({
        managementAppLocator: plugins.management.locator
      }));
    }
  }
  start() {}
  stop() {}
}
exports.IndexLifecycleManagementPlugin = IndexLifecycleManagementPlugin;