"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmLocatorDefinition = exports.ILM_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _navigation = require("./application/services/navigation");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ILM_LOCATOR_ID = 'ILM_LOCATOR_ID';
exports.ILM_LOCATOR_ID = ILM_LOCATOR_ID;
class IlmLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", ILM_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const location = await this.deps.managementAppLocator.getLocation({
        sectionId: 'data',
        appId: _constants.PLUGIN.ID
      });
      switch (params.page) {
        case 'policy_create':
          {
            return {
              ...location,
              path: location.path + (0, _navigation.getPolicyCreatePath)()
            };
          }
        case 'policy_edit':
          {
            return {
              ...location,
              path: location.path + (0, _navigation.getPolicyEditPath)(params.policyName)
            };
          }
        case 'policies_list':
          {
            return {
              ...location,
              path: location.path + (0, _navigation.getPoliciesListPath)()
            };
          }
      }
    });
    this.deps = deps;
  }
}
exports.IlmLocatorDefinition = IlmLocatorDefinition;