"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImageEmbeddable = exports.IMAGE_EMBEDDABLE_TYPE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/embeddable-plugin/public");
var _image_viewer = require("../image_viewer");
var _actions = require("../actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const IMAGE_EMBEDDABLE_TYPE = 'image';
exports.IMAGE_EMBEDDABLE_TYPE = IMAGE_EMBEDDABLE_TYPE;
class ImageEmbeddable extends _public.Embeddable {
  supportedTriggers() {
    return [_actions.imageClickTrigger.id];
  }
  constructor(deps, initialInput, parent) {
    super(initialInput, {
      editable: true,
      editableWithExplicitInput: true
    }, parent);
    (0, _defineProperty2.default)(this, "type", IMAGE_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "ImageEmbeddableViewer", props => {
      const input = (0, _useObservable.default)(props.embeddable.getInput$(), props.embeddable.getInput());
      _react.default.useLayoutEffect(() => {
        Promise.resolve().then(() => _interopRequireWildcard(require('./image_embeddable_lazy')));
      }, []);
      const [hasTriggerActions, setHasTriggerActions] = _react.default.useState(false);
      _react.default.useEffect(() => {
        let cancel = false;

        // hack: timeout to give a chance for a drilldown action to be registered just after it is created by user
        setTimeout(() => {
          if (cancel) return;
          this.deps.actions.hasTriggerActions(_actions.imageClickTrigger.id, {
            embeddable: this
          }).catch(() => false).then(hasActions => !cancel && setHasTriggerActions(hasActions));
        }, 0);
        return () => {
          cancel = true;
        };
      });
      return /*#__PURE__*/_react.default.createElement(_image_viewer.ImageViewerContext.Provider, {
        value: {
          getImageDownloadHref: this.deps.getImageDownloadHref,
          validateUrl: this.deps.validateUrl
        }
      }, /*#__PURE__*/_react.default.createElement(_image_viewer.ImageViewer, {
        className: "imageEmbeddableImage",
        imageConfig: input.imageConfig,
        isScreenshotMode: this.deps.isScreenshotMode(),
        onLoad: () => {
          this.renderComplete.dispatchComplete();
        },
        onError: () => {
          this.renderComplete.dispatchError();
        },
        onClick:
        // note: passing onClick enables the cursor pointer style, so we only pass it if there are compatible actions
        hasTriggerActions ? () => {
          this.deps.actions.executeTriggerActions(_actions.imageClickTrigger.id, {
            embeddable: this
          });
        } : undefined
      }));
    });
    this.deps = deps;
  }
  render(el) {
    super.render(el); // calling super.render initializes renderComplete and setTitle
    el.setAttribute('data-shared-item', '');
    const ImageEmbeddableViewer = this.ImageEmbeddableViewer;
    return /*#__PURE__*/_react.default.createElement(ImageEmbeddableViewer, {
      embeddable: this
    });
  }
  reload() {}
}
exports.ImageEmbeddable = ImageEmbeddable;