"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImageEditorFlyout = ImageEditorFlyout;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _sharedUxFileUpload = require("@kbn/shared-ux-file-upload");
var _sharedUxFilePicker = require("@kbn/shared-ux-file-picker");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _imports = require("../imports");
var _image_viewer = require("../image_viewer/image_viewer");
var _validate_image_config = require("../utils/validate_image_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// use eager version to avoid flickering

/**
 * Shared sizing css for image, upload placeholder, empty and not found state
 * Makes sure the container has not too large height to preserve vertical space for the image configuration in the flyout
 */
const CONTAINER_SIZING_CSS = (0, _react2.css)({
  aspectRatio: `21 / 9`,
  width: `100%`,
  height: `auto`,
  maxHeight: `max(20vh, 180px)`
});
function ImageEditorFlyout(props) {
  var _props$initialImageCo15;
  const isEditing = !!props.initialImageConfig;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [fileId, setFileId] = (0, _react.useState)(() => {
    var _props$initialImageCo, _props$initialImageCo2;
    return ((_props$initialImageCo = props.initialImageConfig) === null || _props$initialImageCo === void 0 ? void 0 : (_props$initialImageCo2 = _props$initialImageCo.src) === null || _props$initialImageCo2 === void 0 ? void 0 : _props$initialImageCo2.type) === 'file' ? props.initialImageConfig.src.fileId : undefined;
  });
  const [fileImageMeta, setFileImageMeta] = (0, _react.useState)(() => {
    var _props$initialImageCo3, _props$initialImageCo4;
    return ((_props$initialImageCo3 = props.initialImageConfig) === null || _props$initialImageCo3 === void 0 ? void 0 : (_props$initialImageCo4 = _props$initialImageCo3.src) === null || _props$initialImageCo4 === void 0 ? void 0 : _props$initialImageCo4.type) === 'file' ? props.initialImageConfig.src.fileImageMeta : undefined;
  });
  const [srcType, setSrcType] = (0, _react.useState)(() => {
    var _props$initialImageCo5, _props$initialImageCo6, _props$initialImageCo7;
    return (_props$initialImageCo5 = (_props$initialImageCo6 = props.initialImageConfig) === null || _props$initialImageCo6 === void 0 ? void 0 : (_props$initialImageCo7 = _props$initialImageCo6.src) === null || _props$initialImageCo7 === void 0 ? void 0 : _props$initialImageCo7.type) !== null && _props$initialImageCo5 !== void 0 ? _props$initialImageCo5 : 'file';
  });
  const [srcUrl, setSrcUrl] = (0, _react.useState)(() => {
    var _props$initialImageCo8, _props$initialImageCo9;
    return ((_props$initialImageCo8 = props.initialImageConfig) === null || _props$initialImageCo8 === void 0 ? void 0 : (_props$initialImageCo9 = _props$initialImageCo8.src) === null || _props$initialImageCo9 === void 0 ? void 0 : _props$initialImageCo9.type) === 'url' ? props.initialImageConfig.src.url : '';
  });
  const [srcUrlError, setSrcUrlError] = (0, _react.useState)(() => {
    var _props$validateUrl$er, _props$validateUrl;
    if (srcUrl) return (_props$validateUrl$er = (_props$validateUrl = props.validateUrl(srcUrl)) === null || _props$validateUrl === void 0 ? void 0 : _props$validateUrl.error) !== null && _props$validateUrl$er !== void 0 ? _props$validateUrl$er : null;
    return null;
  });
  const [isFilePickerOpen, setIsFilePickerOpen] = (0, _react.useState)(false);
  const [sizingObjectFit, setSizingObjectFit] = (0, _react.useState)(() => {
    var _props$initialImageCo10, _props$initialImageCo11, _props$initialImageCo12;
    return (_props$initialImageCo10 = (_props$initialImageCo11 = props.initialImageConfig) === null || _props$initialImageCo11 === void 0 ? void 0 : (_props$initialImageCo12 = _props$initialImageCo11.sizing) === null || _props$initialImageCo12 === void 0 ? void 0 : _props$initialImageCo12.objectFit) !== null && _props$initialImageCo10 !== void 0 ? _props$initialImageCo10 : 'contain';
  });
  const [altText, setAltText] = (0, _react.useState)(() => {
    var _props$initialImageCo13, _props$initialImageCo14;
    return (_props$initialImageCo13 = (_props$initialImageCo14 = props.initialImageConfig) === null || _props$initialImageCo14 === void 0 ? void 0 : _props$initialImageCo14.altText) !== null && _props$initialImageCo13 !== void 0 ? _props$initialImageCo13 : '';
  });
  const [color, setColor, colorErrors] = (0, _eui.useColorPickerState)(props === null || props === void 0 ? void 0 : (_props$initialImageCo15 = props.initialImageConfig) === null || _props$initialImageCo15 === void 0 ? void 0 : _props$initialImageCo15.backgroundColor);
  const isColorInvalid = !!color && !!colorErrors;
  const draftImageConfig = {
    ...props.initialImageConfig,
    src: srcType === 'url' ? {
      type: 'url',
      url: srcUrl
    } : {
      type: 'file',
      fileId,
      fileImageMeta
    },
    altText,
    backgroundColor: colorErrors ? undefined : color,
    sizing: {
      objectFit: sizingObjectFit
    }
  };
  const isDraftImageConfigValid = (0, _validate_image_config.validateImageConfig)(draftImageConfig, {
    validateUrl: props.validateUrl
  });
  const onSave = () => {
    if (!isDraftImageConfigValid) return;
    props.onSave(draftImageConfig);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.editImagetitle",
    defaultMessage: "Edit image"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.addImagetitle",
    defaultMessage: "Add image"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      marginBottom: '-25px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => setSrcType('file'),
    isSelected: srcType === 'file'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.uploadTabLabel",
    defaultMessage: "Upload"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => setSrcType('url'),
    isSelected: srcType === 'url'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.useLinkTabLabel",
    defaultMessage: "Use link"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, srcType === 'file' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDraftImageConfigValid ? /*#__PURE__*/_react.default.createElement(_image_viewer.ImageViewer, {
    css: CONTAINER_SIZING_CSS,
    imageConfig: draftImageConfig,
    onChange: () => setIsFilePickerOpen(true),
    onClear: () => {
      setFileId(undefined);
      setFileImageMeta(undefined);
    },
    containerCSS: (0, _react2.css)`
                  border: ${euiTheme.border.thin};
                  background-color: ${euiTheme.colors.lightestShade};
                `
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    css: (0, _react2.css)`
                  .lazy-load-fallback,
                  .euiFilePicker__prompt {
                    // increase upload image prompt size and lazy load fallback container to look nicer with large flyout and reduce layout shift
                    height: auto;
                    ${CONTAINER_SIZING_CSS};
                  }

                  .lazy-load-fallback {
                    display: flex;
                    justify-content: center;
                    align-items: center;
                  }
                `
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxFileUpload.FileUpload, {
    kind: _imports.imageEmbeddableFileKind.id,
    onDone: files => {
      var _files$;
      return setFileId((_files$ = files[0]) === null || _files$ === void 0 ? void 0 : _files$.id);
    },
    immediate: true,
    initialPromptText: _i18n.i18n.translate('imageEmbeddable.imageEditor.uploadImagePromptText', {
      defaultMessage: 'Select or drag and drop an image'
    }),
    fullWidth: true,
    lazyLoadFallback: /*#__PURE__*/_react.default.createElement("div", {
      className: `lazy-load-fallback`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: 'xl'
    }))
  }), /*#__PURE__*/_react.default.createElement("p", {
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => setIsFilePickerOpen(true),
    "data-test-subj": "imageEmbeddableEditorSelectFiles"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.selectImagePromptText",
    defaultMessage: "Use a previously uploaded image"
  })))))), srcType === 'url' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isDraftImageConfigValid ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: (0, _react2.css)`
                  max-width: none;
                  ${CONTAINER_SIZING_CSS}
                  .euiEmptyPrompt__main {
                    height: 100%;
                  }
                `,
    iconType: "image",
    color: "subdued",
    title: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.byURLNoImageTitle",
      defaultMessage: "No Image"
    })),
    titleSize: 's'
  }) : /*#__PURE__*/_react.default.createElement(_image_viewer.ImageViewer, {
    css: CONTAINER_SIZING_CSS,
    imageConfig: draftImageConfig,
    onError: () => {
      setSrcUrlError(_i18n.i18n.translate('imageEmbeddable.imageEditor.urlFailedToLoadImageErrorMessage', {
        defaultMessage: 'Unable to load image.'
      }));
    },
    containerCSS: (0, _react2.css)`
                  border: ${euiTheme.border.thin};
                  background-color: ${euiTheme.colors.lightestShade};
                `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageURLInputLabel",
      defaultMessage: "Link to image"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageURLHelpText",
      defaultMessage: "Supported file types: png, jpeg, webp, and avif."
    }),
    fullWidth: true,
    isInvalid: !!srcUrlError,
    error: srcUrlError
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": 'imageEmbeddableEditorUrlInput',
    fullWidth: true,
    compressed: true,
    placeholder: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageURLPlaceholderText', {
      defaultMessage: 'Example: https://elastic.co/my-image.png'
    }),
    value: srcUrl,
    onChange: e => {
      const url = e.target.value;
      const {
        isValid,
        error
      } = props.validateUrl(url);
      if (!isValid) {
        setSrcUrlError(error);
      } else {
        setSrcUrlError(null);
      }
      setSrcUrl(e.target.value);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageFillModeLabel",
      defaultMessage: "Fill mode"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    options: [{
      value: 'contain',
      text: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageFillModeContainOptionText', {
        defaultMessage: 'Fit maintaining aspect ratio'
      })
    }, {
      value: 'cover',
      text: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageFillModeCoverOptionText', {
        defaultMessage: 'Fill maintaining aspect ratio'
      })
    }, {
      value: 'fill',
      text: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageFillModeFillOptionText', {
        defaultMessage: 'Stretch to fill'
      })
    }, {
      value: 'none',
      text: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageFillModeNoneOptionText', {
        defaultMessage: "Don't resize"
      })
    }],
    value: sizingObjectFit,
    onChange: e => setSizingObjectFit(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageBackgroundColorLabel",
      defaultMessage: "Background color"
    }),
    fullWidth: true,
    isInvalid: isColorInvalid,
    error: colorErrors
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    fullWidth: true,
    onChange: setColor,
    color: color,
    isInvalid: isColorInvalid,
    isClearable: true,
    placeholder: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageBackgroundColorPlaceholderText', {
      defaultMessage: 'Transparent'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "imageEmbeddable.imageEditor.imageBackgroundDescriptionLabel",
      defaultMessage: "Description"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": 'imageEmbeddableEditorAltInput',
    fullWidth: true,
    compressed: true,
    value: altText,
    maxLength: 1000,
    placeholder: _i18n.i18n.translate('imageEmbeddable.imageEditor.imageAltInputPlaceholderText', {
      defaultMessage: `Alt text that describes the image`
    }),
    onChange: e => {
      setAltText(e.target.value);
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: props.onCancel,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.imageBackgroundCloseButtonText",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSave,
    fill: true,
    isDisabled: !isDraftImageConfigValid,
    "data-test-subj": "imageEmbeddableEditorSave"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "imageEmbeddable.imageEditor.imageBackgroundSaveImageButtonText",
    defaultMessage: "Save"
  }))))), isFilePickerOpen && /*#__PURE__*/_react.default.createElement(_sharedUxFilePicker.FilePicker, {
    kind: _imports.imageEmbeddableFileKind.id,
    shouldAllowDelete: file => {
      var _file$user;
      return props.user ? props.user.profile_uid === ((_file$user = file.user) === null || _file$user === void 0 ? void 0 : _file$user.id) : false;
    },
    multiple: false,
    onClose: () => {
      setIsFilePickerOpen(false);
    },
    onDone: ([file]) => {
      setFileId(file.id);
      setFileImageMeta(file.meta);
      setIsFilePickerOpen(false);
    }
  }));
}