"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParameterForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _number_parameter = require("./number_parameter");
var _string_parameter = require("./string_parameter");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ParameterForm extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "renderInputs", () => {
      return this.props.params.map(param => {
        switch (param.type) {
          case 'number':
            return /*#__PURE__*/_react.default.createElement(_number_parameter.NumberParameter, {
              key: param.id,
              id: param.id,
              label: param.label,
              value: this.props.paramValues[param.id],
              setParameter: this.props.setParameter
            });
          case 'string':
            return /*#__PURE__*/_react.default.createElement(_string_parameter.StringParameter, {
              key: param.id,
              id: param.id,
              label: param.label,
              value: this.props.paramValues[param.id],
              setParameter: this.props.setParameter
            });
          default:
            throw new Error(`Unhandled parameter type ${param.type}`);
        }
      });
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, this.renderInputs());
  }
}
exports.ParameterForm = ParameterForm;
const paramsShape = _propTypes.default.shape({
  id: _propTypes.default.string.isRequired,
  label: _propTypes.default.string.isRequired,
  type: _propTypes.default.string.isRequired
});
ParameterForm.propTypes = {
  params: _propTypes.default.arrayOf(paramsShape).isRequired,
  paramValues: _propTypes.default.object.isRequired,
  setParameter: _propTypes.default.func.isRequired
};