"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _kibana_config = require("./kibana_config");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A service to interact with the configured `kibana.hosts`.
 */
class KibanaService {
  constructor({
    logger,
    config
  }) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "kibanaConfig", void 0);
    this.logger = logger.get('kibana-service');
    this.kibanaConfig = new _kibana_config.KibanaConfig({
      config,
      logger: this.logger
    });
  }
  async start({
    server
  }) {
    const statusHandler = new _handlers.StatusHandler(this.kibanaConfig, this.logger);
    server.addRoute({
      method: 'GET',
      path: '/',
      handler: statusHandler.handler
    });
    server.addRoute({
      method: 'GET',
      path: '/api/status',
      handler: statusHandler.handler
    });
    this.logger.info('Server is ready');
  }
  stop() {
    // nothing to do here yet
  }
}
exports.KibanaService = KibanaService;