"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../../common");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ConfigService {
  constructor() {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "configs", void 0);
    (0, _defineProperty2.default)(this, "isConfigInitialized", void 0);
  }
  setup(httpClient) {
    this.client = httpClient;
    this.configs = {};
    this.isConfigInitialized = {};
  }
  async getGuideConfig(guideId) {
    if (!this.client) {
      throw new Error('ConfigService has not be initialized.');
    }
    // if not initialized yet, get the config from the backend
    if (!this.isConfigInitialized || !this.isConfigInitialized[guideId]) {
      try {
        const {
          config
        } = await this.client.get(`${_common.API_BASE_PATH}/configs/${guideId}`);
        if (!this.isConfigInitialized) this.isConfigInitialized = {};
        this.isConfigInitialized[guideId] = true;
        if (!this.configs) this.configs = {};
        this.configs[guideId] = config;
      } catch (e) {
        // if there is an error, set the isInitialized property to avoid multiple requests
        if (!this.isConfigInitialized) this.isConfigInitialized = {};
        this.isConfigInitialized[guideId] = true;
      }
    }
    // get the config from the configs property
    return (0, _helpers.findGuideConfigByGuideId)(this.configs, guideId);
  }
  async getGuideStatusOnStepCompletion({
    isLastStepInGuide,
    isManualCompletion,
    isStepReadyToComplete
  }) {
    // We want to set the guide status to 'ready_to_complete' if the current step is the last step in the guide
    // and the step is not configured for manual completion
    // or if the current step is configured for manual completion and the last step is ready to complete
    if (isLastStepInGuide && !isManualCompletion || isLastStepInGuide && isManualCompletion && isStepReadyToComplete) {
      return 'ready_to_complete';
    }

    // Otherwise the guide is still in progress
    return 'in_progress';
  }
  async isIntegrationInGuideStep(guideState, integration) {
    if (!guideState || !guideState.isActive) return false;
    const guideConfig = await this.getGuideConfig(guideState.guideId);
    const stepConfig = (0, _helpers.getInProgressStepConfig)(guideConfig, guideState);
    return stepConfig ? stepConfig.integration === integration : false;
  }
}
exports.ConfigService = ConfigService;