"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokDebuggerUIPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _constants = require("../common/constants");
var _register_feature = require("./register_feature");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class GrokDebuggerUIPlugin {
  setup(coreSetup, plugins) {
    (0, _register_feature.registerFeature)(plugins.home);
    const devTool = plugins.devTools.register({
      order: 6,
      title: _i18n.i18n.translate('xpack.grokDebugger.displayName', {
        defaultMessage: 'Grok Debugger'
      }),
      id: _constants.PLUGIN.ID,
      enableRouting: false,
      async mount({
        element,
        theme$
      }) {
        const [coreStart] = await coreSetup.getStartServices();
        const license = await (0, _rxjs.firstValueFrom)(plugins.licensing.license$);
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./render_app')));
        return renderApp(license, element, coreStart, theme$);
      }
    });
    plugins.licensing.license$.subscribe(license => {
      if (!license.isActive && !devTool.isDisabled()) {
        devTool.disable();
      } else if (devTool.isDisabled()) {
        devTool.enable();
      }
    });
  }
  start() {}
  stop() {}
}
exports.GrokDebuggerUIPlugin = GrokDebuggerUIPlugin;