"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asSyncedObservable = asSyncedObservable;
var Rx = _interopRequireWildcard(require("rxjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This is a helper to tie state updates that happen somewhere else back to an react state.
 * It is roughly comparable to `reactDirective`, but does not have to be used from within a
 * template.
 *
 * This is a temporary solution until the state of Workspace internals is moved outside
 * of mutable object to the redux state (at least blocklistedNodes, canEditDrillDownUrls and
 * unblocklist action in this case).
 *
 * @param collectProps Function that collects properties from the scope that should be passed
 * into the observable. All functions passed along will be wrapped to cause a react render
 * and refresh the observable afterwards with a new call to `collectProps`. By doing so, react
 * will receive an update outside of it local state and the results are passed back via the observable.
 */
function asSyncedObservable(collectProps) {
  const boundCollectProps = () => {
    const collectedProps = collectProps();
    Object.keys(collectedProps).forEach(key => {
      const currentValue = collectedProps[key];
      if (typeof currentValue === 'function') {
        collectedProps[key] = (...args) => {
          currentValue(...args);
          subject$.next(boundCollectProps());
        };
      }
    });
    return collectedProps;
  };
  const subject$ = new Rx.BehaviorSubject(boundCollectProps());
  return subject$.asObservable();
}