"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetUninstallTokensMetadataRequestSchema = exports.GetUninstallTokenRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetUninstallTokensMetadataRequestSchema = {
  query: _configSchema.schema.object({
    policyId: _configSchema.schema.maybe(_configSchema.schema.string()),
    perPage: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 20,
      min: 5
    })),
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 1,
      min: 1
    }))
  })
};
exports.GetUninstallTokensMetadataRequestSchema = GetUninstallTokensMetadataRequestSchema;
const GetUninstallTokenRequestSchema = {
  params: _configSchema.schema.object({
    uninstallTokenId: _configSchema.schema.string()
  })
};
exports.GetUninstallTokenRequestSchema = GetUninstallTokenRequestSchema;