"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapPackagePolicySavedObjectToPackagePolicy = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapPackagePolicySavedObjectToPackagePolicy = ({
  /* eslint-disable @typescript-eslint/naming-convention */
  id,
  version,
  attributes: {
    name,
    description,
    namespace,
    enabled,
    is_managed,
    policy_id,
    // `package` is a reserved keyword
    package: packageInfo,
    inputs,
    vars,
    elasticsearch,
    agents,
    revision,
    secret_references,
    updated_at,
    updated_by,
    created_at,
    created_by
    /* eslint-enable @typescript-eslint/naming-convention */
  }
}) => {
  return {
    id,
    name,
    description,
    namespace,
    enabled,
    is_managed,
    policy_id,
    package: packageInfo,
    inputs,
    vars,
    elasticsearch,
    version,
    agents,
    revision,
    secret_references,
    updated_at,
    updated_by,
    created_at,
    created_by
  };
};
exports.mapPackagePolicySavedObjectToPackagePolicy = mapPackagePolicySavedObjectToPackagePolicy;