"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.populatePackagePolicyAssignedAgentsCount = void 0;
var _agent_policy_agent_count = require("../agent_policies/agent_policy_agent_count");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Mutates each of the Package Policies passed on input and adds `agents` property to it with the
 * count of agents currently using the given agent policy.
 * @param esClient
 * @param packagePolicies
 */
const populatePackagePolicyAssignedAgentsCount = async (esClient, packagePolicies) => {
  const agentPolicyIds = Array.from(new Set(packagePolicies.map(policy => policy.policy_id)));
  const agentPolicyAgentCounts = await (0, _agent_policy_agent_count.getAgentCountForAgentPolicies)(esClient, agentPolicyIds);
  for (const packagePolicy of packagePolicies) {
    var _agentPolicyAgentCoun;
    packagePolicy.agents = (_agentPolicyAgentCoun = agentPolicyAgentCounts[packagePolicy.policy_id]) !== null && _agentPolicyAgentCoun !== void 0 ? _agentPolicyAgentCoun : 0;
  }
};
exports.populatePackagePolicyAssignedAgentsCount = populatePackagePolicyAssignedAgentsCount;