"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssets = getAssets;
exports.getAssetsData = getAssetsData;
var _archive = require("../archive");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maybeFilterByDataset = (packageInfo, datasetName) => path => {
  const basePath = `${packageInfo.name}-${packageInfo.version}`;
  const comparePaths = (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.type) === 'input' ? [`${basePath}/agent/input/`, `${basePath}/fields/`] : [`${basePath}/data_stream/${datasetName}/`];
  return comparePaths.some(comparePath => path.includes(comparePath));
};

// paths from RegistryPackage are routes to the assets on EPR
// e.g. `/package/nginx/1.2.0/data_stream/access/fields/fields.yml`
// paths for ArchiveEntry are routes to the assets in the archive
// e.g. `nginx-1.2.0/data_stream/access/fields/fields.yml`
// RegistryPackage paths have a `/package/` prefix compared to ArchiveEntry paths
// and different package and version structure
function getAssets(packageInfo, filter = path => true, datasetName) {
  const paths = (0, _archive.getArchiveFilelist)(packageInfo);
  if (!paths || paths.length === 0) return [];

  // filter out directories
  let assets = paths.filter(path => !path.endsWith('/'));
  if (datasetName) {
    assets = paths.filter(maybeFilterByDataset(packageInfo, datasetName));
  }
  return assets.filter(filter);
}
function getAssetsData(packageInfo, filter = path => true, datasetName) {
  // Gather all asset data
  const assets = getAssets(packageInfo, filter, datasetName);
  const entries = assets.map(path => {
    const buffer = (0, _archive.getAsset)(path);
    return {
      path,
      buffer
    };
  });
  return entries;
}