"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTemplateUrlFromAgentPolicy = exports.SUPPORTED_TEMPLATES_URL_FROM_AGENT_POLICY_CONFIG = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPORTED_TEMPLATES_URL_FROM_AGENT_POLICY_CONFIG = {
  CLOUD_FORMATION: 'cloud_formation_template_url',
  ARM_TEMPLATE: 'arm_template_url'
};
exports.SUPPORTED_TEMPLATES_URL_FROM_AGENT_POLICY_CONFIG = SUPPORTED_TEMPLATES_URL_FROM_AGENT_POLICY_CONFIG;
const getTemplateUrlFromAgentPolicy = (templateUrlFieldName, selectedPolicy) => {
  var _selectedPolicy$packa;
  const cloudFormationTemplateUrl = selectedPolicy === null || selectedPolicy === void 0 ? void 0 : (_selectedPolicy$packa = selectedPolicy.package_policies) === null || _selectedPolicy$packa === void 0 ? void 0 : _selectedPolicy$packa.reduce((acc, packagePolicy) => {
    var _packagePolicy$inputs;
    const findCloudFormationTemplateUrlConfig = (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : _packagePolicy$inputs.reduce((accInput, input) => {
      var _input$config;
      if (accInput !== '') {
        return accInput;
      }
      if (input !== null && input !== void 0 && input.enabled && input !== null && input !== void 0 && (_input$config = input.config) !== null && _input$config !== void 0 && _input$config[templateUrlFieldName]) {
        return input.config[templateUrlFieldName].value;
      }
      return accInput;
    }, '');
    if (findCloudFormationTemplateUrlConfig) {
      return findCloudFormationTemplateUrlConfig;
    }
    return acc;
  }, '');
  return cloudFormationTemplateUrl !== '' ? cloudFormationTemplateUrl : undefined;
};
exports.getTemplateUrlFromAgentPolicy = getTemplateUrlFromAgentPolicy;