"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHrefToObjectInKibanaApp = void 0;
exports.useKibanaLink = useKibanaLink;
var _types = require("../types");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KIBANA_BASE_PATH = '/app/kibana';
const getKibanaLink = (http, path) => {
  return http.basePath.prepend(`${KIBANA_BASE_PATH}#${path}`);
};

/**
 * TODO: This is a temporary solution for getting links to various assets. It is very risky because:
 *
 * 1. The plugin might not exist/be enabled
 * 2. URLs and paths might not always be supported
 *
 * We should migrate to using the new URL service locators.
 *
 * @deprecated {@link Locators} from the new URL service need to be used instead.

 */
const getHrefToObjectInKibanaApp = ({
  type,
  id,
  http
}) => {
  let kibanaAppPath;
  switch (type) {
    case _types.KibanaAssetType.dashboard:
      kibanaAppPath = `/dashboard/${id}`;
      break;
    case _types.KibanaAssetType.search:
      kibanaAppPath = `/discover/${id}`;
      break;
    case _types.KibanaAssetType.visualization:
      kibanaAppPath = `/visualize/edit/${id}`;
      break;
    default:
      return undefined;
  }
  return getKibanaLink(http, kibanaAppPath);
};

/**
 * TODO: This functionality needs to be replaced with use of the new URL service locators
 *
 * @deprecated {@link Locators} from the new URL service need to be used instead.
 */
exports.getHrefToObjectInKibanaApp = getHrefToObjectInKibanaApp;
function useKibanaLink(path = '/') {
  const {
    http
  } = (0, _.useStartServices)();
  return getKibanaLink(http, path);
}