"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _hooks = require("../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TutorialDirectoryHeaderLink = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    application
  } = (0, _hooks.useStartServices)();
  const hasIntegrationsPermissions = application.capabilities.navLinks.integrations;
  const [noticeState] = (0, _react.useState)({
    settingsDataLoaded: false
  });
  return hasIntegrationsPermissions && noticeState.settingsDataLoaded ? /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "link",
    flush: "right",
    href: getHref('integrations')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.homeIntegration.tutorialDirectory.fleetAppButtonText",
    defaultMessage: "Try Integrations"
  }))) : null;
});

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = TutorialDirectoryHeaderLink;
exports.default = _default;
module.exports = exports.default;