"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _hooks = require("../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiKeyField = ({
  apiKeyId,
  length,
  sendGetAPIKey,
  tokenGetter
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [state, setState] = (0, _react.useState)('HIDDEN');
  const [key, setKey] = (0, _react.useState)();
  const tokenMask = (0, _react.useMemo)(() => '•'.repeat(length), [length]);
  const toggleKey = async () => {
    if (state === 'VISIBLE') {
      setState('HIDDEN');
    } else if (state === 'HIDDEN') {
      try {
        setState('LOADING');
        const res = await sendGetAPIKey(apiKeyId);
        if (res.error) {
          throw res.error;
        }
        setKey(tokenGetter(res));
        setState('VISIBLE');
      } catch (err) {
        notifications.toasts.addError(err, {
          title: 'Error'
        });
        setState('HIDDEN');
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    css: (0, _react2.css)`
            font-family: ${euiTheme.font.familyCode};
          `,
    "data-test-subj": "apiKeyField"
  }, state === 'VISIBLE' ? key : tokenMask)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: state === 'VISIBLE' ? _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.hideTokenButtonLabel', {
      defaultMessage: 'Hide token'
    }) : _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.showTokenButtonLabel', {
      defaultMessage: 'Show token'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": state === 'VISIBLE' ? _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.hideTokenButtonLabel', {
      defaultMessage: 'Hide token'
    }) : _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.showTokenButtonLabel', {
      defaultMessage: 'Show token'
    }),
    color: "text",
    onClick: toggleKey,
    iconType: state === 'VISIBLE' ? 'eyeClosed' : 'eye',
    "data-test-subj": "showHideTokenButton"
  }))));
};
exports.ApiKeyField = ApiKeyField;