"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnchorId = exports.OverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../../../../../common/services");
var _hooks = require("../../../../../../../hooks");
var _services2 = require("../../../../../../../services");
var _screenshots = require("./screenshots");
var _readme = require("./readme");
var _details = require("./details");
var _requirements = require("./requirements");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SideBar = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  position: sticky;
  top: 70px;
  padding-top: 50px;
  padding-left: 10px;
  text-overflow: ellipsis;
  max-width: 180px;
  max-height: 500px;
`;
const StyledSideNav = (0, _styledComponents.default)(_eui.EuiSideNav)`
  overflow-y: auto;
  overflow-x: hidden;
`;
const UnverifiedCallout = () => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.epm.verificationWarningCalloutTitle', {
      defaultMessage: 'Integration not verified'
    }),
    iconType: "warning",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.verificationWarningCalloutIntroText",
    defaultMessage: "This integration contains an unsigned package of unknown authenticity. Learn more about {learnMoreLink}.",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        external: true,
        href: docLinks.links.fleet.packageSignatures
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.verificationWarningCalloutLearnMoreLink",
        defaultMessage: "package signatures"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};
const PrereleaseCallout = ({
  packageName,
  packageTitle,
  latestGAVersion
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const overviewPathLatestGA = getHref('integration_details_overview', {
    pkgkey: `${packageName}-${latestGAVersion}`
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "prereleaseCallout",
    title: _i18n.i18n.translate('xpack.fleet.epm.prereleaseWarningCalloutTitle', {
      defaultMessage: 'This is a pre-release version of {packageTitle} integration.',
      values: {
        packageTitle
      }
    }),
    iconType: "iInCircle",
    color: "warning"
  }, latestGAVersion && /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: overviewPathLatestGA,
    color: "warning",
    "data-test-subj": "switchToGABtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.prereleaseWarningCalloutSwitchToGAButton",
    defaultMessage: "Switch to latest GA version"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
};

// some names are too long so they're trimmed at 12 characters long
const getAnchorId = (name, index) => {
  if (!name) return '';
  const baseId = `${name.replaceAll(' ', '-').toLowerCase().slice(0, 12)}`;
  return index ? `${baseId}-${index}` : baseId;
};
exports.getAnchorId = getAnchorId;
const OverviewPage = /*#__PURE__*/(0, _react.memo)(({
  packageInfo,
  integrationInfo,
  latestGAVersion
}) => {
  const screenshots = (0, _react.useMemo)(() => (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.screenshots) || packageInfo.screenshots || [], [integrationInfo, packageInfo.screenshots]);
  const {
    packageVerificationKeyId
  } = (0, _hooks.useGetPackageVerificationKeyId)();
  const isUnverified = (0, _services2.isPackageUnverified)(packageInfo, packageVerificationKeyId);
  const isPrerelease = (0, _services.isPackagePrerelease)(packageInfo.version);
  const [markdown, setMarkdown] = (0, _react.useState)(undefined);
  const [selectedItemId, setSelectedItem] = (0, _react.useState)(undefined);
  const [isSideNavOpenOnMobile, setIsSideNavOpenOnMobile] = (0, _react.useState)(false);
  const anchorsRefs = (0, _react.useRef)(new Map());
  const selectItem = id => {
    var _anchorsRefs$current$;
    setSelectedItem(id);
    (_anchorsRefs$current$ = anchorsRefs.current.get(id)) === null || _anchorsRefs$current$ === void 0 ? void 0 : _anchorsRefs$current$.scrollIntoView({
      behavior: 'smooth'
    });
  };
  const toggleOpenOnMobile = () => {
    setIsSideNavOpenOnMobile(!isSideNavOpenOnMobile);
  };
  const readmePath = integrationInfo && (0, _services.isIntegrationPolicyTemplate)(integrationInfo) && integrationInfo !== null && integrationInfo !== void 0 && integrationInfo.readme ? integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.readme : packageInfo.readme || '';
  (0, _react.useEffect)(() => {
    (0, _hooks.sendGetFileByPath)(readmePath).then(res => {
      setMarkdown(res.data || '');
    });
  }, [readmePath]);
  const extractHeadingsWithIndices = markDown => {
    if (!markDown) return [];
    const regex = /^\s*#+\s+(.+)/;
    return markDown.split('\n').map((line, position) => {
      return {
        line,
        position
      };
    }).filter(obj => obj.line.match(regex));
  };
  const getName = heading => heading.replace(/^#+\s*/, '');
  const createItem = (0, _react.useCallback)((heading, options = {}) => {
    // NOTE: Duplicate `name` values will cause `id` collisions
    const name = getName(heading.line);
    const id = getAnchorId(name, heading.position + 1);
    return {
      id,
      name,
      isSelected: selectedItemId === id,
      onClick: () => selectItem(id),
      ...options
    };
  }, [selectedItemId]);

  // get the headings and creates a nested structure as requested by EuiSideNav
  const headingsToNavItems = (0, _react.useCallback)(headings => {
    const options = {
      forceOpen: true
    };
    return headings.reduce((acc, heading, index) => {
      if (heading.line.startsWith('## ')) {
        const item = createItem(heading, options);
        acc.push(item);
      } else if (heading.line.startsWith('### ')) {
        const subGroup = createItem(heading, options);
        let i = index + 1;
        while (i < headings.length && headings[i].line.startsWith('#### ')) {
          var _subGroup$items;
          const subGroupItem = createItem(headings[i], options);
          if (!(subGroup !== null && subGroup !== void 0 && subGroup.items)) subGroup.items = [];
          (_subGroup$items = subGroup.items) === null || _subGroup$items === void 0 ? void 0 : _subGroup$items.push(subGroupItem);
          i++;
        }
        const prevIndex = acc.length - 1;
        if (prevIndex >= 0) {
          var _acc$prevIndex, _acc$prevIndex2, _acc$prevIndex2$items;
          if (!((_acc$prevIndex = acc[prevIndex]) !== null && _acc$prevIndex !== void 0 && _acc$prevIndex.items)) acc[prevIndex].items = [];
          (_acc$prevIndex2 = acc[prevIndex]) === null || _acc$prevIndex2 === void 0 ? void 0 : (_acc$prevIndex2$items = _acc$prevIndex2.items) === null || _acc$prevIndex2$items === void 0 ? void 0 : _acc$prevIndex2$items.push(subGroup);
        } else {
          var _acc$, _acc$2, _acc$2$items;
          // this handles a case where the headings only have ### and no ##
          const fakeItem = createItem({
            line: '',
            position: heading.position
          }, options);
          acc.push(fakeItem);
          if (!((_acc$ = acc[0]) !== null && _acc$ !== void 0 && _acc$.items)) acc[0].items = [];
          (_acc$2 = acc[0]) === null || _acc$2 === void 0 ? void 0 : (_acc$2$items = _acc$2.items) === null || _acc$2$items === void 0 ? void 0 : _acc$2$items.push(subGroup);
        }
      }
      return acc;
    }, []);
  }, [createItem]);
  const headingsWithIndices = (0, _react.useMemo)(() => extractHeadingsWithIndices(markdown), [markdown]);
  const navItems = (0, _react.useMemo)(() => headingsToNavItems(headingsWithIndices), [headingsToNavItems, headingsWithIndices]);
  const h1 = (0, _react.useMemo)(() => headingsWithIndices.find(h => h.line.startsWith('# ')), [headingsWithIndices]);
  const sideNavItems = (0, _react.useMemo)(() => {
    const name = `${h1 ? getName(h1.line) : ''}`;
    const id = getAnchorId(name, h1 ? (h1 === null || h1 === void 0 ? void 0 : h1.position) + 1 : 1);
    return [{
      name,
      id,
      onClick: () => selectItem(id),
      items: navItems
    }];
  }, [h1, navItems]);
  const requireAgentRootPrivileges = (0, _services.isRootPrivilegesRequired)(packageInfo);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    "data-test-subj": "epm.OverviewPage"
  }, /*#__PURE__*/_react.default.createElement(SideBar, {
    grow: 2
  }, sideNavItems ? /*#__PURE__*/_react.default.createElement(StyledSideNav, {
    mobileTitle: "Nav Items",
    toggleOpenOnMobile: toggleOpenOnMobile,
    isOpenOnMobile: isSideNavOpenOnMobile,
    items: sideNavItems
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    className: "eui-textBreakWord"
  }, isUnverified && /*#__PURE__*/_react.default.createElement(UnverifiedCallout, null), isPrerelease && /*#__PURE__*/_react.default.createElement(PrereleaseCallout, {
    packageName: packageInfo.name,
    packageTitle: packageInfo.title,
    latestGAVersion: latestGAVersion
  }), packageInfo.readme ? /*#__PURE__*/_react.default.createElement(_readme.Readme, {
    markdown: markdown,
    packageName: packageInfo.name,
    version: packageInfo.version,
    refs: anchorsRefs
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    alignItems: "flexStart"
  }, requireAgentRootPrivileges ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_requirements.Requirements, null)) : null, screenshots.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_screenshots.Screenshots, {
    images: screenshots,
    packageName: packageInfo.name,
    version: packageInfo.version
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_details.Details, {
    packageInfo: packageInfo,
    integrationInfo: integrationInfo
  })))));
});
exports.OverviewPage = OverviewPage;