"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchBox = ({
  searchTerm,
  setSearchTerm,
  selectedCategory,
  setCategory,
  categories,
  availableSubCategories,
  setSelectedSubCategory,
  selectedSubCategory,
  setUrlandReplaceHistory
}) => {
  var _categories$find;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onQueryChange = e => {
    const queryText = e.target.value;
    setSearchTerm(queryText);
    setUrlandReplaceHistory({
      searchString: queryText,
      categoryId: selectedCategory,
      subCategoryId: selectedSubCategory
    });
  };
  const onCategoryButtonClick = () => {
    if (selectedSubCategory) {
      if (setSelectedSubCategory) setSelectedSubCategory(undefined);
      setUrlandReplaceHistory({
        categoryId: selectedCategory,
        subCategoryId: ''
      });
    } else {
      setCategory('');
      if (setSelectedSubCategory) setSelectedSubCategory(undefined);
      setUrlandReplaceHistory({
        searchString: '',
        categoryId: '',
        subCategoryId: ''
      });
    }
  };
  const selectedCategoryTitle = selectedCategory ? (_categories$find = categories.find(category => category.id === selectedCategory)) === null || _categories$find === void 0 ? void 0 : _categories$find.title : undefined;
  const getCategoriesLabel = (0, _react.useMemo)(() => {
    var _availableSubCategori;
    const selectedSubCategoryTitle = selectedSubCategory && availableSubCategories ? (_availableSubCategori = availableSubCategories.find(subCat => subCat.id === selectedSubCategory)) === null || _availableSubCategori === void 0 ? void 0 : _availableSubCategori.title : undefined;
    if (selectedCategoryTitle && selectedSubCategoryTitle) {
      return `${selectedCategoryTitle}, ${selectedSubCategoryTitle}`;
    } else if (selectedCategoryTitle) {
      return `${selectedCategoryTitle}`;
    } else return '';
  }, [availableSubCategories, selectedCategoryTitle, selectedSubCategory]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "epmList.searchBar",
    placeholder: _i18n.i18n.translate('xpack.fleet.epmList.searchPackagesPlaceholder', {
      defaultMessage: 'Search for integrations'
    }),
    value: searchTerm,
    onChange: e => onQueryChange(e),
    isClearable: true,
    incremental: true,
    fullWidth: true,
    prepend: selectedCategoryTitle ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "epmList.categoryBadge",
      size: "xs",
      style: {
        display: 'flex',
        alignItems: 'center',
        fontWeight: euiTheme.font.weight.bold,
        backgroundColor: euiTheme.colors.lightestShade
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, "Searching category: ")), getCategoriesLabel, /*#__PURE__*/_react.default.createElement("button", {
      "data-test-subj": "epmList.categoryBadge.closeBtn",
      onClick: onCategoryButtonClick,
      "aria-label": "Remove filter",
      style: {
        padding: euiTheme.size.xs,
        paddingTop: '2px'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      color: "text",
      size: "s",
      style: {
        width: 'auto',
        padding: 0,
        backgroundColor: euiTheme.colors.lightestShade
      }
    }))) : undefined
  });
};
exports.SearchBox = SearchBox;