"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridColumn = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _reactWindow = require("react-window");
var _i18nReact = require("@kbn/i18n-react");
var _reactVirtualized = require("react-virtualized");
var _components = require("../../../../components");
var _package_card = require("../package_card");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VirtualizedRow = ({
  index,
  children,
  style,
  onHeightChange
}) => {
  const ref = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (ref.current) {
      onHeightChange(index, ref.current.clientHeight);
    }
  }, [index, onHeightChange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: style
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })));
};
const GridColumn = ({
  list,
  showMissingIntegrationMessage = false,
  showCardLabels = false,
  isLoading
}) => {
  const itemsSizeRefs = (0, _react.useRef)(new Map());
  const listRef = (0, _react.useRef)(null);
  const onHeightChange = (0, _react.useCallback)((index, size) => {
    itemsSizeRefs.current.set(index, size);
    if (listRef.current) {
      listRef.current.resetAfterIndex(index);
    }
  }, []);
  if (isLoading) return /*#__PURE__*/_react.default.createElement(_components.Loading, null);
  if (!list.length) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      gutterSize: "l",
      columns: 3
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 3
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, showMissingIntegrationMessage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.missingIntegrationPlaceholder",
      defaultMessage: "We didn't find any integrations matching your search term. Please try another keyword or browse using the categories on the left."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmList.noPackagesFoundPlaceholder",
      defaultMessage: "No integrations found"
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactVirtualized.WindowScroller, {
    onScroll: ({
      scrollTop
    }) => {
      if (listRef.current) {
        listRef.current.scrollTo(scrollTop);
      }
    }
  }, () => /*#__PURE__*/_react.default.createElement(_eui.EuiAutoSizer, {
    disableHeight: true
  }, ({
    width
  }) => /*#__PURE__*/_react.default.createElement(_reactWindow.VariableSizeList, {
    style: {
      height: '100%'
    },
    ref: listRef,
    layout: "vertical",
    itemCount: Math.ceil(list.length / 3),
    itemSize: index => {
      var _itemsSizeRefs$curren;
      const test = (_itemsSizeRefs$curren = itemsSizeRefs.current.get(index)) !== null && _itemsSizeRefs$curren !== void 0 ? _itemsSizeRefs$curren : 200;
      return test;
    },
    height: window.innerHeight // plus Don't see an integration message
    ,
    estimatedItemSize: 200,
    width: width
  }, ({
    index,
    style
  }) => {
    return /*#__PURE__*/_react.default.createElement(VirtualizedRow, {
      index: index,
      style: style,
      onHeightChange: onHeightChange
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      gutterSize: "l",
      columns: 3
    }, list.slice(index * 3, index * 3 + 3).map(item => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: item.id
        // Ensure that cards wrapped in EuiTours/EuiPopovers correctly inherit the full grid row height
        ,
        css: (0, _react2.css)`
                                & > .euiPopover,
                                & > .euiPopover > .euiPopover__anchor,
                                & > .euiPopover > .euiPopover__anchor > .euiCard {
                                  height: 100%;
                                }
                              `
      }, /*#__PURE__*/_react.default.createElement(_package_card.PackageCard, (0, _extends2.default)({}, item, {
        showLabels: showCardLabels
      })));
    })));
  }))));
};
exports.GridColumn = GridColumn;