"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YamlCodeEditorWithPlaceholder = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CodeEditorContainer = _styledComponents.default.div`
  min-height: 0;
  position: relative;
  height: 116px;
`;
const CodeEditorPlaceholder = (0, _styledComponents.default)(_eui.EuiTextColor).attrs(props => ({
  color: 'subdued',
  size: 'xs'
}))`
  position: absolute;
  top: 0;
  left: 0;
  // Matches monaco editor
  font-family: Menlo, Monaco, 'Courier New', monospace;
  font-size: 12px;
  line-height: 21px;
  pointer-events: none;
`;
const CODE_EDITOR_OPTIONS = {
  minimap: {
    enabled: false
  },
  ariaLabel: _i18n.i18n.translate('xpack.fleet.settings.yamlCodeEditor', {
    defaultMessage: 'YAML Code Editor'
  }),
  scrollBeyondLastLine: false,
  wordWrap: 'on',
  wrappingIndent: 'indent',
  automaticLayout: true,
  tabSize: 2,
  // To avoid left margin
  lineNumbers: 'off',
  lineNumbersMinChars: 0,
  glyphMargin: false,
  folding: false,
  lineDecorationsWidth: 0
};
const YamlCodeEditorWithPlaceholder = props => {
  const {
    placeholder,
    disabled,
    ...editorProps
  } = props;
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      style: {
        height: '116px'
      },
      language: "yaml",
      isCopyable: false,
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement("pre", null, editorProps.value));
  }
  return /*#__PURE__*/_react.default.createElement(CodeEditorContainer, null, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, (0, _extends2.default)({
    languageId: "yaml",
    width: "100%",
    height: "116px",
    options: CODE_EDITOR_OPTIONS
  }, editorProps)), (!editorProps.value || editorProps.value === '') && /*#__PURE__*/_react.default.createElement(CodeEditorPlaceholder, null, placeholder));
};
exports.YamlCodeEditorWithPlaceholder = YamlCodeEditorWithPlaceholder;