"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormLogstashSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _logstash_instructions = require("../logstash_instructions");
var _multi_row_input = require("../multi_row_input");
var _output_form_secret_form_row = require("./output_form_secret_form_row");
var _encryption_key_required_callout = require("./encryption_key_required_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputFormLogstashSection = props => {
  const {
    inputs,
    useSecretsStorage,
    onToggleSecretStorage,
    hasEncryptedSavedObjectConfigured
  } = props;
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const [isFirstLoad, setIsFirstLoad] = _react.default.useState(true);
  (0, _react.useEffect)(() => {
    if (!isFirstLoad) return;
    setIsFirstLoad(false);
    // populate the secret input with the value of the plain input in order to re-save the output with secret storage
    if (useSecretsStorage) {
      if (inputs.sslKeyInput.value && !inputs.sslKeySecretInput.value) {
        inputs.sslKeySecretInput.setValue(inputs.sslKeyInput.value);
        inputs.sslKeyInput.clear();
      }
    }
  }, [useSecretsStorage, inputs.sslKeyInput, inputs.sslKeySecretInput, isFirstLoad, setIsFirstLoad]);
  const onToggleSecretAndClearValue = secretEnabled => {
    if (secretEnabled) {
      inputs.sslKeyInput.clear();
    } else {
      inputs.sslKeySecretInput.setValue('');
    }
    onToggleSecretStorage(secretEnabled);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hasEncryptedSavedObjectConfigured && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_encryption_key_required_callout.EncryptionKeyRequiredCallout, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_logstash_instructions.LogstashInstructions, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.logstashHostsInputPlaceholder', {
      defaultMessage: 'Specify host'
    }),
    sortable: false,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.logstashHostsInputDescription",
      defaultMessage: "Specify the addresses that your agents will use to connect to Logstash. {guideLink}.",
      values: {
        guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.logstashSettings,
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.fleetSettingsLink",
          defaultMessage: "Learn more"
        }))
      }
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.logstashHostsInputLabel', {
      defaultMessage: 'Logstash hosts'
    })
  }, inputs.logstashHostsInput.props)), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder', {
      defaultMessage: 'Specify certificate authority'
    }),
    label: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputLabel', {
      defaultMessage: 'Server SSL certificate authorities (optional)'
    }),
    multiline: true,
    sortable: false
  }, inputs.sslCertificateAuthoritiesInput.props)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",
      defaultMessage: "Client SSL certificate"
    })
  }, inputs.sslCertificateInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslCertificateInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslCertificateInputPlaceholder', {
      defaultMessage: 'Specify ssl certificate'
    })
  }))), !useSecretsStorage ? /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",
      defaultMessage: "Client SSL certificate key"
    })
  }, inputs.sslKeyInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretAndClearValue
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslKeyInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder', {
      defaultMessage: 'Specify certificate key'
    })
  }))) : /*#__PURE__*/_react.default.createElement(_output_form_secret_form_row.SecretFormRow, (0, _extends2.default)({
    fullWidth: true,
    title: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeySecretInputTitle', {
      defaultMessage: 'Client SSL certificate key'
    })
  }, inputs.sslKeySecretInput.formRowProps, {
    useSecretsStorage: useSecretsStorage,
    onToggleSecretStorage: onToggleSecretAndClearValue,
    cancelEdit: inputs.sslKeySecretInput.cancelEdit
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({
    fullWidth: true,
    rows: 5
  }, inputs.sslKeySecretInput.props, {
    "data-test-subj": "sslKeySecretInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.sslKeySecretInputPlaceholder', {
      defaultMessage: 'Specify certificate key'
    })
  }))));
};
exports.OutputFormLogstashSection = OutputFormLogstashSection;