"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentHealth = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _agent_status = require("../../../../../../common/services/agent_status");
var _hooks = require("../../../hooks");
var _hooks2 = require("../agent_details_page/hooks");
var _agent_upgrade_modal = require("./agent_upgrade_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Status = {
  Healthy: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.healthyStatusText",
    defaultMessage: "Healthy"
  })),
  Offline: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.offlineStatusText",
    defaultMessage: "Offline"
  })),
  Inactive: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _uiTheme.euiLightVars.euiColorDarkShade
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.inactiveStatusText",
    defaultMessage: "Inactive"
  })),
  Unenrolled: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _uiTheme.euiLightVars.euiColorDisabled
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.unenrolledStatusText",
    defaultMessage: "Unenrolled"
  })),
  Unhealthy: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.unhealthyStatusText",
    defaultMessage: "Unhealthy"
  })),
  Updating: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.updatingStatusText",
    defaultMessage: "Updating"
  }))
};
function getStatusComponent(status) {
  switch (status) {
    case 'error':
    case 'degraded':
      return Status.Unhealthy;
    case 'inactive':
      return Status.Inactive;
    case 'offline':
      return Status.Offline;
    case 'unenrolling':
    case 'enrolling':
    case 'updating':
      return Status.Updating;
    case 'unenrolled':
      return Status.Unenrolled;
    default:
      return Status.Healthy;
  }
}
const WrappedEuiCallOut = (0, _styledComponents.default)(_eui.EuiCallOut)`
  white-space: wrap !important;
`;
const AgentHealth = ({
  agent,
  fromDetails
}) => {
  const {
    last_checkin: lastCheckIn,
    last_checkin_message: lastCheckInMessage
  } = agent;
  const msLastCheckIn = new Date(lastCheckIn || 0).getTime();
  const lastCheckInMessageText = lastCheckInMessage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.checkinMessageText",
    defaultMessage: "Last checkin message: {lastCheckinMessage}",
    values: {
      lastCheckinMessage: lastCheckInMessage
    }
  }) : null;
  const lastCheckinText = msLastCheckIn ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.checkInTooltipText",
    defaultMessage: "Last checked in {lastCheckIn}",
    values: {
      lastCheckIn: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        value: msLastCheckIn
      })
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.noCheckInTooltipText",
    defaultMessage: "Never checked in"
  });
  const previousToOfflineStatus = (0, _react.useMemo)(() => {
    if (!fromDetails || agent.status !== 'offline') {
      return;
    }
    return (0, _agent_status.getPreviousAgentStatusForOfflineAgents)(agent);
  }, [fromDetails, agent]);
  const [isUpgradeModalOpen, setIsUpgradeModalOpen] = (0, _react.useState)(false);
  const refreshAgent = (0, _hooks2.useAgentRefresh)();
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, lastCheckinText), /*#__PURE__*/_react.default.createElement("p", null, lastCheckInMessageText), (0, _agent_status.isStuckInUpdating)(agent) ? (0, _agent_status.isAgentInFailedUpgradeState)(agent) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.failedUpgradeTooltipText",
      defaultMessage: "Agent upgrade failed. Consider restarting the upgrade."
    }) : /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.restartUpgradeTooltipText",
      defaultMessage: "Agent may be stuck updating. Consider restarting the upgrade."
    })) : null)
  }, (0, _agent_status.isStuckInUpdating)(agent) && !fromDetails ? /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textNoWrap"
  }, getStatusComponent(agent.status), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getStatusComponent(agent.status), previousToOfflineStatus ? getStatusComponent(previousToOfflineStatus) : null)), fromDetails && (0, _agent_status.isStuckInUpdating)(agent) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(WrappedEuiCallOut, {
    iconType: "warning",
    size: "m",
    color: "warning",
    title: (0, _agent_status.isAgentInFailedUpgradeState)(agent) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.failedUpgradeTitle",
      defaultMessage: "Agent upgrade is stuck in failed state."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.stuckUpdatingTitle",
      defaultMessage: "Agent may be stuck updating."
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.stuckUpdatingText",
    defaultMessage: "{stuckMessage} Consider restarting the upgrade. {learnMore}",
    values: {
      stuckMessage: (0, _agent_status.isAgentInFailedUpgradeState)(agent) ? 'Agent upgrade failed.' : 'Agent has been updating for a while, and may be stuck.',
      learnMore: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.upgradeElasticAgent,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.upgradeAgentsDocLink",
        defaultMessage: "Learn more"
      })))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    onClick: () => {
      setIsUpgradeModalOpen(true);
    },
    "data-test-subj": "restartUpgradeBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.restartUpgradeBtn",
    defaultMessage: "Restart upgrade"
  })))) : null, isUpgradeModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_upgrade_modal.AgentUpgradeAgentModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsUpgradeModalOpen(false);
      refreshAgent();
    },
    isUpdating: true
  })));
};
exports.AgentHealth = AgentHealth;