"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../hooks");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasetFilter = /*#__PURE__*/(0, _react.memo)(({
  selectedDatasets,
  onToggleDataset
}) => {
  const {
    unifiedSearch,
    data
  } = (0, _hooks.useStartServices)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [datasetValues, setDatasetValues] = (0, _react.useState)([_constants.AGENT_DATASET]);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(prevIsOpen => !prevIsOpen), [setIsOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsOpen(false), [setIsOpen]);
  (0, _react.useEffect)(() => {
    const fetchValues = async () => {
      setIsLoading(true);
      try {
        const fields = await data.dataViews.getFieldsForWildcard({
          pattern: _constants.AGENT_LOG_INDEX_PATTERN
        });
        const fieldsMap = fields.reduce((acc, curr) => {
          acc[curr.name] = curr;
          return acc;
        }, {});
        const newDataView = await data.dataViews.create({
          title: _constants.AGENT_LOG_INDEX_PATTERN,
          fields: fieldsMap
        });
        const values = await unifiedSearch.autocomplete.getValueSuggestions({
          indexPattern: newDataView,
          field: _constants.DATASET_FIELD,
          query: ''
        });
        if (values.length > 0) setDatasetValues(values.sort());
      } catch (e) {
        setDatasetValues([_constants.AGENT_DATASET]);
      }
      setIsLoading(false);
    };
    fetchValues();
  }, [data.dataViews, unifiedSearch.autocomplete]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "agentList.datasetFilterBtn",
      iconType: "arrowDown",
      onClick: togglePopover,
      isSelected: isOpen,
      isLoading: isLoading,
      numFilters: datasetValues.length,
      hasActiveFilters: selectedDatasets.length > 0,
      numActiveFilters: selectedDatasets.length
    }, _i18n.i18n.translate('xpack.fleet.agentLogs.datasetSelectText', {
      defaultMessage: 'Dataset'
    })),
    isOpen: isOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, datasetValues.map(dataset => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: selectedDatasets.includes(dataset) ? 'on' : undefined,
    key: dataset,
    onClick: () => onToggleDataset(dataset)
  }, dataset)));
});
exports.DatasetFilter = DatasetFilter;