"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appendOnSaveQueryParamsToPath = appendOnSaveQueryParamsToPath;
var _queryString = require("query-string");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function appendOnSaveQueryParamsToPath({
  path,
  policy,
  paramsToApply,
  mappingOptions = {}
}) {
  const [basePath, queryStringIn] = path.split('?');
  const queryParams = (0, _queryString.parse)(queryStringIn);
  paramsToApply.forEach(paramName => {
    const paramOptions = mappingOptions[paramName];
    if (paramOptions) {
      const [paramKey, paramValue] = createQueryParam(paramName, paramOptions, policy.policy_id);
      if (paramKey && paramValue) {
        queryParams[paramKey] = paramValue;
      }
    }
  });
  const queryString = (0, _queryString.stringify)(queryParams);
  return basePath + (queryString ? `?${queryString}` : '');
}
function createQueryParam(name, opts, policyId) {
  if (!opts) {
    return [];
  }
  if (typeof opts === 'boolean' && opts) {
    return [name, 'true'];
  }
  const paramKey = opts.renameKey ? opts.renameKey : name;
  const paramValue = opts.policyIdAsValue ? policyId : 'true';
  return [paramKey, paramValue];
}