"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostInstallAzureArmTemplateModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@tanstack/react-query");
var _get_azure_arm_props_from_package_policy = require("../../../../../../../services/get_azure_arm_props_from_package_policy");
var _use_create_azure_arm_template_url = require("../../../../../../../hooks/use_create_azure_arm_template_url");
var _azure_arm_template_guide = require("../../../../../../../components/azure_arm_template_guide");
var _hooks = require("../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PostInstallAzureArmTemplateModal = ({
  onConfirm,
  onCancel,
  agentPolicy,
  packagePolicy
}) => {
  var _apyKeysData$data, _apyKeysData$data$ite;
  const {
    data: apyKeysData
  } = (0, _reactQuery.useQuery)(['azureArmTemplateApiKeys', {
    agentPolicyId: agentPolicy.id
  }], () => (0, _hooks.sendGetEnrollmentAPIKeys)({
    page: 1,
    perPage: 1,
    kuery: `policy_id:${agentPolicy.id}`
  }));
  const azureArmTemplateProps = (0, _get_azure_arm_props_from_package_policy.getAzureArmPropsFromPackagePolicy)(packagePolicy);
  const enrollmentToken = apyKeysData === null || apyKeysData === void 0 ? void 0 : (_apyKeysData$data = apyKeysData.data) === null || _apyKeysData$data === void 0 ? void 0 : (_apyKeysData$data$ite = _apyKeysData$data.items[0]) === null || _apyKeysData$data$ite === void 0 ? void 0 : _apyKeysData$data$ite.api_key;
  const {
    azureArmTemplateUrl,
    error,
    isError,
    isLoading
  } = (0, _use_create_azure_arm_template_url.useCreateAzureArmTemplateUrl)({
    enrollmentAPIKey: enrollmentToken,
    azureArmTemplateProps
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "postInstallAzureArmTemplateModal",
    onClose: onCancel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "confirmAzureArmTemplateModalTitleText"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAzureArmTemplateModalModalTitle",
    defaultMessage: "ARM Template deployment"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_azure_arm_template_guide.AzureArmTemplateGuide, {
    azureAccountType: azureArmTemplateProps.azureAccountType,
    agentPolicy: agentPolicy,
    enrollmentToken: enrollmentToken
  }), error && isError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: error,
    color: "danger",
    iconType: "error"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "confirmAzureArmTemplateModalCancelButton",
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAzureArmTemplateModal.cancelButton",
    defaultMessage: "Add ARM Template later"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "confirmAzureArmTemplateModalConfirmButton",
    onClick: () => {
      window.open(azureArmTemplateUrl);
      onConfirm();
    },
    fill: true,
    color: "primary",
    isLoading: isLoading,
    isDisabled: isError
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAzureArmTemplateModalConfirmButtonLabel",
    defaultMessage: "Launch ARM Template"
  }))));
};
exports.PostInstallAzureArmTemplateModal = PostInstallAzureArmTemplateModal;