"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyFormSystemMonitoringCheckbox = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyFormSystemMonitoringCheckbox = ({
  withSysMonitoring,
  updateSysMonitoring
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "agentPolicyFormSystemMonitoringCheckbox",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.systemMonitoringText",
      defaultMessage: "Collect system logs and metrics"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.systemMonitoringTooltipText",
        defaultMessage: "This will also add a {system} integration to collect system logs and metrics.",
        values: {
          system: /*#__PURE__*/_react.default.createElement(_components.AgentPolicyPackageBadge, {
            pkgName: 'system',
            pkgTitle: 'System'
          })
        }
      }),
      position: "right",
      type: "iInCircle",
      color: "subdued"
    })),
    checked: withSysMonitoring,
    onChange: () => {
      updateSysMonitoring(!withSysMonitoring);
    },
    "data-test-subj": "agentPolicyFormSystemMonitoringCheckbox"
  }));
};
exports.AgentPolicyFormSystemMonitoringCheckbox = AgentPolicyFormSystemMonitoringCheckbox;