"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionsPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _services = require("./services");
var _react_expression_renderer_wrapper = require("./react_expression_renderer_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
/**
 * Expressions public setup contract, extends {@link ExpressionsServiceSetup}
 */

/**
 * Expressions public start contrect, extends {@link ExpressionServiceStart}
 */

class ExpressionsPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "expressions", new _services.ExpressionsService({
      logger: ExpressionsPublicPlugin.logger
    }));
  }
  setup(core) {
    const {
      expressions
    } = this;
    const {
      renderers
    } = expressions;
    (0, _services.setRenderersRegistry)(renderers);
    (0, _services.setExpressionsService)(expressions);
    const setup = expressions.setup((0, _lodash.pick)(core, 'getStartServices'));
    return Object.freeze(setup);
  }
  start(core) {
    (0, _services.setNotifications)(core.notifications);
    const {
      expressions
    } = this;
    const loader = async (element, expression, params) => {
      const {
        ExpressionLoader
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./loader')));
      return new ExpressionLoader(element, expression, params);
    };
    const render = async (element, data, options) => {
      const {
        ExpressionRenderHandler
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./render')));
      const handler = new ExpressionRenderHandler(element, options);
      handler.render(data);
      return handler;
    };
    const start = {
      ...expressions.start(),
      loader,
      render,
      ReactExpressionRenderer: _react_expression_renderer_wrapper.ReactExpressionRenderer
    };
    return Object.freeze(start);
  }
  stop() {
    this.expressions.stop();
  }
}
exports.ExpressionsPublicPlugin = ExpressionsPublicPlugin;
(0, _defineProperty2.default)(ExpressionsPublicPlugin, "logger", {
  ...console,
  // eslint-disable-next-line no-console
  fatal: console.error,
  get() {
    return this;
  },
  isLevelEnabled: () => true
});