"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorRenderer = exports.errorRendererFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/presentation-util-plugin/public");
var _common = require("@kbn/presentation-util-plugin/common");
var _components = require("../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const errorStrings = {
  getDisplayName: () => _i18n.i18n.translate('expressionError.renderer.error.displayName', {
    defaultMessage: 'Error information'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionError.renderer.error.helpDescription', {
    defaultMessage: 'Render error data in a way that is helpful to users'
  })
};
const ErrorComponent = (0, _public2.withSuspense)(_components.LazyErrorRenderComponent);
const getErrorRenderer = (theme$ = _common.defaultTheme$) => () => ({
  name: 'error',
  displayName: errorStrings.getDisplayName(),
  help: errorStrings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(ErrorComponent, (0, _extends2.default)({
      onLoaded: handlers.done
    }, config, {
      parentNode: domNode
    })))), domNode);
  }
});
exports.getErrorRenderer = getErrorRenderer;
const errorRendererFactory = core => getErrorRenderer(core.theme.theme$);
exports.errorRendererFactory = errorRendererFactory;