"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataTypesLabels = exports.DataTypes = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let DataTypes;
exports.DataTypes = DataTypes;
(function (DataTypes) {
  DataTypes["SYNTHETICS"] = "synthetics";
  DataTypes["UPTIME"] = "uptime";
  DataTypes["UX"] = "ux";
  DataTypes["MOBILE"] = "mobile";
  DataTypes["METRICS"] = "infra_metrics";
  DataTypes["LOGS"] = "infra_logs";
  DataTypes["ALERTS"] = "alerts";
})(DataTypes || (exports.DataTypes = DataTypes = {}));
const DataTypesLabels = {
  [DataTypes.UX]: _i18n.i18n.translate('xpack.exploratoryView.uxLabel', {
    defaultMessage: 'User experience (RUM)'
  }),
  [DataTypes.SYNTHETICS]: _i18n.i18n.translate('xpack.exploratoryView.syntheticsLabel', {
    defaultMessage: 'Synthetics monitoring'
  }),
  [DataTypes.UPTIME]: _i18n.i18n.translate('xpack.exploratoryView.uptimeLabel', {
    defaultMessage: 'Uptime'
  }),
  [DataTypes.METRICS]: _i18n.i18n.translate('xpack.exploratoryView.metricsLabel', {
    defaultMessage: 'Metrics'
  }),
  [DataTypes.LOGS]: _i18n.i18n.translate('xpack.exploratoryView.logsLabel', {
    defaultMessage: 'Logs'
  }),
  [DataTypes.MOBILE]: _i18n.i18n.translate('xpack.exploratoryView.mobileExperienceLabel', {
    defaultMessage: 'Mobile experience'
  }),
  [DataTypes.ALERTS]: _i18n.i18n.translate('xpack.exploratoryView.alertsLabel', {
    defaultMessage: 'Alerts'
  })
};
exports.DataTypesLabels = DataTypesLabels;