"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlStorageContext = exports.NEW_SERIES_KEY = void 0;
exports.UrlStorageContextProvider = UrlStorageContextProvider;
exports.allSeriesKey = void 0;
exports.convertAllShortSeries = convertAllShortSeries;
exports.reportTypeKey = void 0;
exports.useSeriesStorage = useSeriesStorage;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _exploratory_view_url = require("../configurations/exploratory_view_url");
var _url_constants = require("../configurations/constants/url_constants");
var _telemetry = require("../utils/telemetry");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UrlStorageContext = /*#__PURE__*/(0, _react.createContext)({});
exports.UrlStorageContext = UrlStorageContext;
function convertAllShortSeries(allShortSeries) {
  return (allShortSeries !== null && allShortSeries !== void 0 ? allShortSeries : []).map(shortSeries => convertFromShortUrl(shortSeries));
}
const allSeriesKey = 'sr';
exports.allSeriesKey = allSeriesKey;
const reportTypeKey = 'reportType';
exports.reportTypeKey = reportTypeKey;
function UrlStorageContextProvider({
  children,
  storage
}) {
  const [allSeries, setAllSeries] = (0, _react.useState)(() => {
    var _storage$get;
    return convertAllShortSeries((_storage$get = storage.get(allSeriesKey)) !== null && _storage$get !== void 0 ? _storage$get : []);
  });
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(() => Date.now());
  const [chartTimeRangeContext, setChartTimeRangeContext] = (0, _react.useState)();
  const [reportType, setReportType] = (0, _react.useState)(() => {
    var _get;
    return (_get = storage.get(reportTypeKey)) !== null && _get !== void 0 ? _get : '';
  });
  const [firstSeries, setFirstSeries] = (0, _react.useState)();
  const trackEvent = (0, _public.useUiTracker)();
  (0, _react.useEffect)(() => {
    const firstSeriesT = allSeries === null || allSeries === void 0 ? void 0 : allSeries[0];
    setFirstSeries(firstSeriesT);
  }, [allSeries, storage]);
  const setSeries = (0, _react.useCallback)((seriesIndex, newValue) => {
    setAllSeries(prevAllSeries => {
      const seriesWithCurrentBreakdown = prevAllSeries.findIndex(series => series.breakdown);
      const newStateRest = prevAllSeries.map((series, index) => {
        if (index === seriesIndex) {
          return {
            ...newValue,
            breakdown: seriesWithCurrentBreakdown === seriesIndex || seriesWithCurrentBreakdown === -1 ? newValue.breakdown : undefined
          };
        }
        return series;
      });
      if (prevAllSeries.length === seriesIndex) {
        return [...newStateRest, newValue];
      }
      return [...newStateRest];
    });
  }, []);
  const removeSeries = (0, _react.useCallback)(seriesIndex => {
    setAllSeries(prevAllSeries => prevAllSeries.filter((seriesT, index) => index !== seriesIndex));
  }, []);
  const getSeries = (0, _react.useCallback)(seriesIndex => {
    return allSeries[seriesIndex];
  }, [allSeries]);
  const applyChanges = (0, _react.useCallback)(onApply => {
    const allShortSeries = allSeries.map(series => (0, _exploratory_view_url.convertToShortUrl)(series));
    storage.set(reportTypeKey, reportType);
    storage.set(allSeriesKey, allShortSeries);
    setLastRefresh(Date.now());
    (0, _telemetry.trackTelemetryOnApply)(trackEvent, allSeries, reportType);
    if (onApply) {
      onApply();
    }
  }, [allSeries, storage, trackEvent, reportType]);
  const value = {
    applyChanges,
    storage,
    getSeries,
    setSeries,
    removeSeries,
    allSeries,
    lastRefresh,
    setLastRefresh,
    setReportType,
    reportType,
    chartTimeRangeContext,
    setChartTimeRangeContext,
    firstSeries: firstSeries
  };
  return /*#__PURE__*/_react.default.createElement(UrlStorageContext.Provider, {
    value: value
  }, children);
}
function useSeriesStorage() {
  return (0, _react.useContext)(UrlStorageContext);
}
function convertFromShortUrl(newValue) {
  const {
    dt,
    op,
    st,
    bd,
    ft,
    time,
    rdf,
    mt,
    h,
    n,
    c,
    spa,
    ...restSeries
  } = newValue;
  return {
    operationType: op,
    seriesType: st,
    breakdown: bd,
    filters: ft,
    time: time,
    reportDefinitions: rdf,
    dataType: dt,
    selectedMetricField: mt,
    hidden: h,
    name: n,
    color: c,
    showPercentileAnnotations: spa,
    ...restSeries
  };
}
const NEW_SERIES_KEY = 'new-series';
exports.NEW_SERIES_KEY = NEW_SERIES_KEY;